/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.gui.mode;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.gui.mode.GuiSignalModeConfiguration;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.signal.output.mode.SignalOutputHandlerPulse;

public class GuiSignalModeConfigurationPulse
extends GuiSignalModeConfiguration {
    public int length;

    public GuiSignalModeConfigurationPulse(int delay, int length) {
        super(delay);
        this.length = length;
    }

    public GuiSignalModeConfigurationPulse(SignalOutputHandler handler) {
        super(handler);
        int n;
        if (handler instanceof SignalOutputHandlerPulse) {
            SignalOutputHandlerPulse pulse = (SignalOutputHandlerPulse)handler;
            n = pulse.pulseLength;
        } else {
            n = 10;
        }
        this.length = n;
    }

    @Override
    public SignalMode getMode() {
        return SignalMode.PULSE;
    }

    @Override
    public GuiSignalModeConfiguration copy() {
        return new GuiSignalModeConfigurationPulse(this.delay, this.length);
    }

    @Override
    public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("delay", this.delay);
        nbt.putInt("length", this.length);
        return this.getMode().create(component, this.delay, nbt, false);
    }

    @Override
    public MutableComponent description(int configuredDelay) {
        return super.description(configuredDelay).append(" ").append((Component)Component.translatable((String)"gui.signal.length").append(": " + this.length));
    }
}

