/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.output.mode;

import net.minecraft.nbt.CompoundTag;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.signal.schedule.SignalScheduleTicket;

public class SignalOutputHandlerExtender
extends SignalOutputHandler {
    public final int pulseLength;
    public boolean stateBefore;
    public SignalScheduleTicket pulseStart;
    public SignalScheduleTicket pulseEnd;

    public SignalOutputHandlerExtender(ISignalComponent component, int delay, CompoundTag nbt) {
        super(component, delay, nbt);
        this.pulseLength = nbt.contains("length") ? nbt.getInt("length") : 10;
        this.stateBefore = nbt.getBoolean("before");
    }

    @Override
    public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
        return super.getBandwidth();
    }

    @Override
    public SignalMode getMode() {
        return SignalMode.EXTENDER;
    }

    @Override
    public void performStateChange(SignalState state) {
        super.performStateChange(state);
        if (state.any()) {
            this.pulseStart = null;
        } else {
            this.pulseStart = null;
            this.pulseEnd = null;
        }
    }

    @Override
    public void queue(SignalState state) {
        try {
            int bandwidth = this.getBandwidth();
            boolean current = state.any();
            if (!this.stateBefore && current) {
                if (this.pulseEnd != null) {
                    this.pulseEnd.markObsolete();
                    this.pulseEnd = null;
                } else if (this.pulseStart == null) {
                    SignalState startState = SignalState.create(bandwidth).fill(true);
                    this.pulseStart = LittleTiles.TICKERS.schedule(this, startState, this.delay);
                }
            } else if (this.stateBefore && !current) {
                if (this.pulseEnd != null) {
                    this.pulseEnd.markObsolete();
                    this.pulseEnd = null;
                }
                this.pulseEnd = LittleTiles.TICKERS.schedule(this, SignalState.create(bandwidth), this.delay + this.pulseLength);
            }
            this.stateBefore = current;
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @Override
    public void write(boolean preview, CompoundTag nbt) {
        nbt.putInt("length", this.pulseLength);
        nbt.putBoolean("before", this.stateBefore);
        if (preview) {
            return;
        }
        if (this.pulseStart != null) {
            nbt.putInt("start", this.pulseStart.getDelay());
        }
        if (this.pulseEnd != null) {
            nbt.putInt("end", this.pulseEnd.getDelay());
        }
    }
}

