/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.output.mode;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.signal.schedule.SignalScheduleTicket;

public class SignalOutputHandlerToggle
extends SignalOutputHandler {
    public SignalState stateBefore;
    public SignalState result;

    public SignalOutputHandlerToggle(ISignalComponent component, int delay, CompoundTag nbt, SignalState stateBefore, SignalState result) {
        super(component, delay, nbt);
        this.stateBefore = stateBefore;
        this.result = result;
    }

    @Override
    public SignalMode getMode() {
        return SignalMode.TOGGLE;
    }

    public void triggerToggle() {
        if (this.result == null) {
            try {
                int bandwidth = this.component.getBandwidth();
                this.result = SignalState.create(bandwidth);
                this.result = this.result.fill(this.component.getState());
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
        this.result = this.result.invert();
        this.performStateChange(this.result);
    }

    @Override
    public void queue(SignalState state) {
        try {
            int bandwidth = this.component.getBandwidth();
            if (this.stateBefore == null) {
                this.stateBefore = SignalState.create(bandwidth);
                this.result = SignalState.create(bandwidth);
            }
            for (int i = 0; i < bandwidth; ++i) {
                if (!this.stateBefore.is(i) && state.is(i)) {
                    this.result = this.result.set(i, !this.result.is(i));
                }
                this.stateBefore = this.stateBefore.set(i, state.is(i));
            }
            LittleTiles.TICKERS.schedule(this, this.result, this.delay);
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @Override
    public void write(boolean preview, CompoundTag nbt) {
        if (this.stateBefore != null) {
            try {
                nbt.putInt("bandwidth", this.component.getBandwidth());
                nbt.put("before", this.stateBefore.save());
                nbt.put("result", this.result.save());
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
        if (preview) {
            return;
        }
        List<SignalScheduleTicket> tickets = LittleTiles.TICKERS.findTickets(this.component, this);
        ListTag list = new ListTag();
        for (int i = 0; i < tickets.size(); ++i) {
            SignalScheduleTicket ticket = tickets.get(i);
            list.add((Object)new IntArrayTag(new int[]{ticket.getDelay(), ticket.getState().number()}));
        }
        if (!list.isEmpty()) {
            nbt.put("tickets", (Tag)list);
        }
    }
}

