/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.type.map.ChunkLayerMapList;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.client.render.tile.LittleRenderBoxItem;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.item.ItemLittleWrench;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.signal.SignalState;

public class LittleItemHolder
extends LittleStructure {
    @StructureDirectional(color=0xFF0001)
    public StructureRelative frame;
    @StructureDirectional
    public Facing facing;
    @StructureDirectional
    public Vec3f topRight;
    public ItemStack stack;
    public boolean locked;
    public boolean whitelist;
    public List<CreativeIngredient> filter;

    public LittleItemHolder(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    public void loadSettings(CompoundTag nbt, HolderLookup.Provider provider) {
        this.locked = nbt.getBoolean("locked");
        this.whitelist = nbt.getBoolean("f_white");
        if (nbt.contains("filter")) {
            ListTag list = nbt.getList("filter", 10);
            this.filter = new ArrayList<CreativeIngredient>();
            for (int i = 0; i < list.size(); ++i) {
                this.filter.add(CreativeIngredient.load((HolderLookup.Provider)provider, (CompoundTag)list.getCompound(i)));
            }
        } else {
            this.filter = null;
        }
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("stack"));
        this.loadSettings(nbt, provider);
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("stack", this.stack.saveOptional(provider));
        nbt.putBoolean("locked", this.locked);
        nbt.putBoolean("f_white", this.whitelist);
        if (this.filter != null) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.filter.size(); ++i) {
                list.add((Object)this.filter.get(i).save(provider));
            }
            nbt.put("filter", (Tag)list);
        } else {
            nbt.remove("filter");
        }
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    public boolean wrenchInteract(Player player) {
        LittleTilesGuiRegistry.ITEM_HOLDER.open(player, this);
        return true;
    }

    public boolean canBeFoundInFilterList(ItemStack stack) {
        if (this.filter == null) {
            return false;
        }
        for (CreativeIngredient ingredient : this.filter) {
            if (!ingredient.is(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide || this.locked && !(player.getMainHandItem().getItem() instanceof ItemLittleWrench)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack mainStack = player.getMainHandItem();
        if (mainStack.isEmpty() && !this.stack.isEmpty()) {
            if (player.getInventory().add(player.getInventory().selected, this.stack)) {
                this.stack = ItemStack.EMPTY;
            }
            this.updateInput();
            this.updateStructure(true);
        } else if (this.stack.isEmpty() && this.canBeFoundInFilterList(mainStack) == this.whitelist) {
            this.stack = mainStack.copy();
            if (!player.getAbilities().instabuild) {
                mainStack.shrink(1);
            }
            this.updateInput();
            this.updateStructure(true);
        }
        return InteractionResult.SUCCESS;
    }

    public void updateInput() {
        this.getInput(0).updateState(SignalState.of(!this.stack.isEmpty()));
    }

    @Override
    public void getRenderingBoxes(BlockPos pos, ChunkLayerMapList<LittleRenderBox> cubes) {
        LittleBox littleBox = this.frame.getBox();
        AlignedBox box = littleBox.getBox(this.frame.getGrid());
        if (!this.stack.isEmpty()) {
            cubes.add(RenderType.cutout(), (Object)new LittleRenderBoxItem(this, box, littleBox));
        }
    }
}

