/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.bed;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;
import team.creative.littletiles.common.structure.type.bed.LittleBed;

public class LittleBedEventHandler {
    @SubscribeEvent
    public void continueSleep(CanContinueSleepingEvent event) {
        ILittleBedPlayerExtension b;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ILittleBedPlayerExtension && (b = (ILittleBedPlayerExtension)livingEntity).getBed() != null) {
            event.setContinueSleeping(true);
        }
    }

    @SubscribeEvent
    public void isSleepingLocationAllowed(CanPlayerSleepEvent event) {
        ServerPlayer player;
        LittleBed bed;
        ServerPlayer serverPlayer = event.getEntity();
        if (serverPlayer instanceof Player && (bed = ((ILittleBedPlayerExtension)(player = serverPlayer)).getBed()) != null && bed.getSleepingPlayer() == player) {
            event.setProblem(null);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        LittleBed bed = ((ILittleBedPlayerExtension)event.getEntity()).getBed();
        if (bed != null) {
            bed.wakeUp();
        }
        ((ILittleBedPlayerExtension)event.getEntity()).setBed(null);
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        LittleBed bed = ((ILittleBedPlayerExtension)event.getEntity()).getBed();
        if (bed != null) {
            bed.wakeUp();
        }
        ((ILittleBedPlayerExtension)event.getEntity()).setBed(null);
    }
}

