/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.premade.signal;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class LittleSignalDisplay
extends LittleStructurePremade {
    public static final int renderDistance = 64;
    @StructureDirectional(color=0xFF0001)
    public StructureRelative frame;
    @StructureDirectional
    public Facing facing;
    @StructureDirectional
    public Vec3f topRight;
    private int textureId = -1;

    public LittleSignalDisplay(LittleStructurePremade.LittlePremadeType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
    }

    @Override
    public void receiveInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("pixels") && this.isClient()) {
            this.updateTexture();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateTexture() {
        if (this.textureId == -1) {
            this.textureId = GlStateManager._genTexture();
        }
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glBindTexture((int)3553, (int)this.textureId);
        int bandwidth = this.getOutput(0).getBandwidth();
        SignalState state = this.getOutput(0).getState();
        ByteBuffer buffer = ByteBuffer.allocateDirect(bandwidth * 3);
        for (int i = 0; i < bandwidth; ++i) {
            if (state.is(i)) {
                buffer.put((byte)-1);
                buffer.put((byte)-1);
                buffer.put((byte)-1);
                continue;
            }
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
        }
        buffer.rewind();
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)4, (int)4, (int)0, (int)6407, (int)5121, (ByteBuffer)buffer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(PoseStack pose, MultiBufferSource buffer, BlockPos pos, float partialTickTime) {
        super.renderTick(pose, buffer, pos, partialTickTime);
        if (this.textureId == -1) {
            this.updateTexture();
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.bindTexture((int)this.textureId);
        RenderSystem.setShaderTexture((int)0, (int)this.textureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        pose.pushPose();
        AlignedBox box = this.frame.getBox().getBox(this.frame.getGrid());
        BoxFace face = BoxFace.get((Facing)this.facing);
        if (this.facing.positive) {
            box.setMax(this.facing.axis, box.getMin(this.facing.axis) + 0.005f);
        } else {
            box.setMin(this.facing.axis, box.getMax(this.facing.axis) - 0.005f);
        }
        Axis uAxis = face.getTexUAxis();
        Axis vAxis = face.getTexVAxis();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder builder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (BoxCorner corner : face.corners) {
            builder.addVertex(pose.last().pose(), box.get(corner.x), box.get(corner.y), box.get(corner.z)).setUv(corner.isFacingPositive(uAxis) != this.topRight.get(uAxis) > 0.0f ? 1.0f : 0.0f, corner.isFacingPositive(vAxis) != this.topRight.get(vAxis) > 0.0f ? 1.0f : 0.0f);
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        pose.popPose();
        RenderSystem.disableCull();
        RenderSystem.disableBlend();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public double getMaxRenderDistance() {
        return 64.0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return this.frame.getBox().getBB(this.frame.getGrid());
    }

    @Override
    public void unload() {
        super.unload();
        if (this.isClient() && this.textureId != -1) {
            GlStateManager._deleteTexture((int)this.textureId);
        }
    }
}

