/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.common.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import team.creative.creativecore.common.util.math.box.BoxesVoxelShape;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.math.vec.LittleHitResult;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Unique
    private Entity asEntity() {
        return (Entity)this;
    }

    @Inject(method={"pick"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, require=1)
    public void pick(double reach, float partialTicks, boolean fluid, CallbackInfoReturnable<HitResult> info, Vec3 pos, Vec3 view, Vec3 look) {
        double d;
        Entity entity = this.asEntity();
        HitResult result = (HitResult)info.getReturnValue();
        if (result != null) {
            d = pos.distanceTo(result.getLocation());
        } else if (entity instanceof Player) {
            Player p = (Player)entity;
            d = PlayerUtils.getReach((Player)p);
        } else {
            d = 4.0;
        }
        double reachDistance = d;
        LittleHitResult hit = ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(entity.level())).getHit(pos, look, reachDistance);
        if (hit != null) {
            info.setReturnValue((Object)hit);
        }
    }

    @WrapOperation(method={"Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collectCandidateStepUpHeights(Lnet/minecraft/world/phys/AABB;Ljava/util/List;FF)[F")}, require=1)
    private float[] collectCandidateStepUpHeights(AABB bb, List<VoxelShape> list, float maxStepHeight, float yMotion, Operation<float[]> original, @Local(ordinal=0) Vec3 motion) {
        ArrayList<VoxelShape> remaining = null;
        boolean found = false;
        FloatArraySet floatset = new FloatArraySet(4);
        SingletonList temp = null;
        double maxStepUp = -1.0;
        for (int i = 0; i < list.size(); ++i) {
            BoxesVoxelShape b;
            VoxelShape voxelShape = list.get(i);
            if (voxelShape instanceof BoxesVoxelShape && (b = (BoxesVoxelShape)voxelShape).requiresAdvancedEntityStep()) {
                double movedY;
                boolean zFirst;
                if (temp == null) {
                    temp = new SingletonList(null);
                }
                temp.setElement((Object)b);
                AABB stepBB = bb.move(0.0, (double)maxStepHeight, 0.0);
                double movedX = motion.x;
                double movedZ = motion.z;
                boolean bl = zFirst = Math.abs(movedX) < Math.abs(movedZ);
                if (zFirst && movedZ != 0.0 && (movedZ = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)stepBB, (Iterable)temp, (double)movedZ)) != 0.0) {
                    stepBB = stepBB.move(0.0, 0.0, movedZ);
                }
                if (movedX != 0.0 && (movedX = Shapes.collide((Direction.Axis)Direction.Axis.X, (AABB)stepBB, (Iterable)temp, (double)movedX)) != 0.0) {
                    stepBB = stepBB.move(movedX, 0.0, 0.0);
                }
                if (!zFirst && movedZ != 0.0 && (movedZ = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)stepBB, (Iterable)temp, (double)movedZ)) != 0.0) {
                    stepBB = stepBB.move(0.0, 0.0, movedZ);
                }
                if ((movedX != 0.0 || movedZ != 0.0) && (movedY = Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)stepBB, (Iterable)temp, (double)(-maxStepHeight)) + (double)maxStepHeight) > 0.0) {
                    maxStepUp = Math.max(maxStepUp, movedY);
                }
                if (!found && remaining == null && i > 0) {
                    remaining = new ArrayList();
                    for (int j = 0; j < i; ++j) {
                        remaining.add(list.get(j));
                    }
                }
                found = true;
                continue;
            }
            if (!found) continue;
            if (remaining == null) {
                remaining = new ArrayList<VoxelShape>();
            }
            remaining.add(list.get(i));
        }
        if (!found || remaining != null) {
            float[] result = (float[])original.call(new Object[]{bb, remaining == null ? list : remaining, Float.valueOf(maxStepHeight), Float.valueOf(yMotion)});
            for (int j = 0; j < result.length; ++j) {
                floatset.add(result[j]);
            }
        }
        if (found && maxStepUp != -1.0) {
            floatset.add((float)maxStepUp);
        }
        float[] afloat = floatset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }
}

