/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.mc;

import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.client.IFakeRenderingBlock;
import team.creative.littletiles.api.common.block.ILittleMCBlock;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class BlockFlowingLava
extends Block
implements ILittleMCBlock,
IFakeRenderingBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public final Holder<Block> still;

    public BlockFlowingLava(Holder<Block> still) {
        super(BlockBehaviour.Properties.of().liquid().strength(1.5f, 6.0f));
        this.still = still;
    }

    @Override
    public Block asVanillaBlock() {
        return this;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace());
    }

    @Override
    public boolean noCollision() {
        return true;
    }

    @Override
    public boolean isFluid(TagKey<Fluid> fluid) {
        return fluid.equals((Object)FluidTags.LAVA);
    }

    @Override
    public boolean checkEntityCollision() {
        return true;
    }

    @Override
    public void entityCollided(IParentCollection parent, LittleTile tile, Entity entity) {
        AABB box = entity.getBoundingBox();
        LittleVec center = new LittleVec(parent.getGrid(), new Vec3((box.minX + box.maxX) / 2.0, (box.minY + box.maxY) / 2.0, (box.minZ + box.maxZ) / 2.0).subtract(Vec3.atLowerCornerOf((Vec3i)parent.getPos())));
        LittleBox testBox = new LittleBox(center, 1, 1, 1);
        if (tile.intersectsWith(testBox)) {
            double scale = 0.05;
            Vec3 vec = new Vec3(((Direction)tile.getState().getValue((Property)BlockStateProperties.FACING)).step()).normalize().scale(scale);
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec));
        }
    }

    @Override
    public boolean canBeConvertedToVanilla() {
        return false;
    }

    @Override
    public BlockState getFakeState(BlockState state) {
        return Blocks.LAVA.defaultBlockState();
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result) {
        if (player.getMainHandItem().getItem() instanceof BucketItem && LittleTiles.CONFIG.general.allowFlowingLava) {
            Direction facing = (Direction)tile.getState().getValue((Property)BlockStateProperties.FACING);
            int index = facing.ordinal() + 1;
            BlockState newState = index >= Direction.values().length ? (this == LittleTilesRegistry.FLOWING_LAVA ? ((Block)LittleTilesRegistry.LAVA.value()).defaultBlockState() : ((Block)LittleTilesRegistry.WHITE_LAVA.value()).defaultBlockState()) : (BlockState)tile.getState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.values()[index]);
            parent.getBE().updateTiles(x -> {
                LittleTile newFlowing = new LittleTile(newState, -1, box.copy());
                x.noneStructureTiles().remove(tile, box);
                x.noneStructureTiles().add(newFlowing);
            });
            return InteractionResult.SUCCESS;
        }
        return ILittleMCBlock.super.use(parent, tile, box, player, result);
    }

    @Override
    public Vector3d getFogColor(IParentCollection parent, LittleTile tile, Entity entity, Vector3d originalColor, float partialTicks) {
        return new Vector3d((double)0.6f, (double)0.1f, 0.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canBeRenderCombined(LittleTile one, LittleTile two) {
        if (two.getBlock() == this) {
            return true;
        }
        return two.getBlock() == LittleTilesRegistry.LAVA.value();
    }

    @Override
    public BlockState transform(BlockState state, IntMatrix3c matrix, LittleVec doubledCenter) {
        return (BlockState)state.setValue(FACING, (Comparable)Facing.get((Direction)((Direction)state.getValue(FACING))).transform(matrix).toVanilla());
    }
}

