/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.gui.AnimationPreview;
import team.creative.littletiles.mixin.client.render.LightTextureAccessor;

public interface GuiAnimationViewerStorage {
    public static final Camera FAKE_CAMERA = new Camera();

    public static int[][] makeLightBright() {
        int[][] pixels = new int[16][16];
        LightTextureAccessor texture = (LightTextureAccessor)Minecraft.getInstance().gameRenderer.lightTexture();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                pixels[x][y] = texture.getLightPixels().getPixelRGBA(x, y);
                texture.getLightPixels().setPixelRGBA(x, y, -1);
            }
        }
        texture.getLightTexture().upload();
        return pixels;
    }

    public static void resetLight(int[][] pixels) {
        LightTextureAccessor texture = (LightTextureAccessor)Minecraft.getInstance().gameRenderer.lightTexture();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                texture.getLightPixels().setPixelRGBA(x, y, pixels[x][y]);
            }
        }
        texture.getLightTexture().upload();
    }

    public boolean isReady();

    public double longestSide();

    public AABB overall();

    public Vec3d center();

    public boolean highlightSelected();

    public void highlightSelected(boolean var1);

    @OnlyIn(value=Dist.CLIENT)
    public Iterable<AnimationPreview> previewsToRender();

    @OnlyIn(value=Dist.CLIENT)
    default public void renderAll(PoseStack pose, Matrix4f projection, Minecraft mc) {
        int[][] pixels = GuiAnimationViewerStorage.makeLightBright();
        for (AnimationPreview preview : this.previewsToRender()) {
            this.renderPreview(pose, projection, preview, mc);
        }
        GuiAnimationViewerStorage.resetLight(pixels);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderPreview(PoseStack pose, Matrix4f projection, AnimationPreview preview, Minecraft mc) {
        preview.setupRendering(pose);
        preview.animation.getRenderManager().setupRender(FAKE_CAMERA, null, false, false);
        preview.animation.getRenderManager().compileSections(FAKE_CAMERA);
        this.renderChunkLayer(preview, RenderType.solid(), pose, projection);
        mc.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).setBlurMipmap(false, (Integer)mc.options.mipmapLevels().get() > 0);
        this.renderChunkLayer(preview, RenderType.cutoutMipped(), pose, projection);
        mc.getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).restoreLastBlurMipmap();
        this.renderChunkLayer(preview, RenderType.cutout(), pose, projection);
        this.renderChunkLayer(preview, RenderType.translucent(), pose, projection);
    }

    default public void renderChunkLayer(AnimationPreview preview, RenderType layer, PoseStack pose, Matrix4f matrix) {
        layer.setupRenderState();
        ShaderInstance shaderinstance = RenderSystem.getShader();
        RenderSystem.setupShaderLights((ShaderInstance)shaderinstance);
        shaderinstance.setDefaultUniforms(VertexFormat.Mode.QUADS, pose.last().pose(), matrix, Minecraft.getInstance().getWindow());
        shaderinstance.apply();
        preview.animation.getRenderManager().renderChunkLayer(layer, pose, 0.0, 0.0, 0.0, matrix, shaderinstance.CHUNK_OFFSET);
        shaderinstance.clear();
        VertexBuffer.unbind();
        layer.clearRenderState();
    }
}

