/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.control.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.control.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.mc.LevelUtils;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.common.gui.control.GuiColorProgressBar;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.ingredient.BlockIngredient;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.ingredient.NotEnoughIngredientsException;
import team.creative.littletiles.common.item.ItemBlockIngredient;
import team.creative.littletiles.common.item.ItemColorIngredient;
import team.creative.littletiles.common.item.ItemLittleBag;

public class GuiBag
extends GuiConfigure {
    public SimpleContainer bagInventory;
    public GuiInventoryGrid bagInventoryGui;
    public LittleIngredients bag;
    public SimpleContainer input = new SimpleContainer(1);
    private List<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
    private List<IGuiInventory> inventoriesInv = new ArrayList<IGuiInventory>();
    public final GuiSyncLocal<CompoundTag> RELOAD = this.getSyncHolder().register("reload", nbt -> {
        DataResult result = ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, nbt);
        this.tool.set((ItemStack)result.getOrThrow());
        this.load();
    });
    public final GuiSyncLocal<StringTag> DROP_COLOR = this.getSyncHolder().register("drop_color", nbt -> {
        int amount;
        ItemColorIngredient.ColorIngredientType type = ItemColorIngredient.ColorIngredientType.getType(nbt.getAsString());
        ColorIngredient color = this.bag.get(ColorIngredient.class);
        if (color != null && !color.isEmpty() && (amount = Math.min(type.getIngredient(color), 262144)) > 0) {
            type.setIngredient(color, type.getIngredient(color) - amount);
            Player player = this.getPlayer();
            LittleInventory inventory = new LittleInventory(player);
            ItemStack colorStack = ItemColorIngredient.generateItemStack(type, amount);
            if (!inventory.addStack(colorStack)) {
                LevelUtils.dropItem((Player)player, (ItemStack)colorStack);
            }
            this.saveBagInventory();
            this.sendUpdateToClient();
            this.tick();
        }
    });

    public GuiBag(ContainerSlotView view) {
        super("bag", view);
        this.registerEventClick(x -> {
            if (x.control instanceof GuiColorProgressBar) {
                this.DROP_COLOR.send((Tag)StringTag.valueOf((String)x.control.name));
            }
        });
    }

    public void sendUpdateToClient() {
        if (this.isClient()) {
            return;
        }
        DataResult dataresult = ItemStack.CODEC.encode((Object)this.tool.get(), (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag());
        this.RELOAD.send((Tag)((CompoundTag)dataresult.getOrThrow()));
    }

    protected GuiInventoryGrid addInventory(GuiInventoryGrid inventory) {
        this.inventories.add((IGuiInventory)inventory);
        this.inventoriesInv.add(0, (IGuiInventory)inventory);
        return inventory;
    }

    public void create() {
        this.sendUpdateToClient();
        this.flow = GuiFlow.STACK_Y;
        this.bag = ((ItemLittleBag)this.tool.get().getItem()).getInventory(this.tool.get());
        ColorIngredient unit = this.bag.get(ColorIngredient.class);
        GuiParent upper = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)upper);
        GuiParent left = new GuiParent();
        upper.add((GuiControl)left);
        GuiParent right = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        upper.add(right.setAlign(Align.STRETCH).setExpandableX());
        GuiInventoryGrid inputInventory = new GuiInventoryGrid("input", (Container)this.input).addListener(x -> {
            Player player = this.getPlayer();
            ItemStack input = this.input.getItem(0);
            Item patt0$temp = input.getItem();
            if (patt0$temp instanceof ILittleIngredientInventory) {
                ILittleIngredientInventory inv = (ILittleIngredientInventory)patt0$temp;
                ingredients = inv.getInventory(input);
                boolean containsBlocks = ingredients.contains(BlockIngredient.class);
                boolean containsColor = ingredients.contains(ColorIngredient.class);
                LittleIngredients remaining = this.bag.add(ingredients);
                ((ItemLittleBag)this.tool.get().getItem()).setInventory(this.tool.get(), this.bag, null);
                if (remaining == null) {
                    remaining = new LittleIngredients();
                }
                if (remaining.copy().sub(ingredients.copy()) != null) {
                    if (containsBlocks) {
                        this.clearItemCache();
                        player.playSound(SoundEvents.ITEM_FRAME_PLACE, 1.0f, 1.0f);
                    }
                    if (containsColor) {
                        player.playSound(SoundEvents.BREWING_STAND_BREW, 1.0f, 1.0f);
                        this.sendUpdateToClient();
                    }
                }
                inv.setInventory(input, remaining, null);
                this.saveBagInventory();
            } else {
                ingredients = LittleIngredient.extractWithoutCount(this.provider(), input, true);
                if (ingredients != null) {
                    ingredients.scale(input.getCount());
                    boolean containsBlocks = ingredients.contains(BlockIngredient.class);
                    boolean containsColor = ingredients.contains(ColorIngredient.class);
                    LittleIngredients overflow = this.bag.add(ingredients);
                    if (overflow == null || !overflow.contains(BlockIngredient.class) && !overflow.contains(ColorIngredient.class)) {
                        input.setCount(0);
                        ((ItemLittleBag)this.tool.get().getItem()).setInventory(this.tool.get(), this.bag, null);
                        LittleInventory inventory = new LittleInventory(player);
                        try {
                            if (overflow != null) {
                                inventory.give(overflow);
                            }
                        }
                        catch (NotEnoughIngredientsException.NotEnoughSpaceException notEnoughSpaceException) {
                            // empty catch block
                        }
                        if (containsBlocks) {
                            this.clearItemCache();
                            player.playSound(SoundEvents.ITEM_FRAME_PLACE, 1.0f, 1.0f);
                        }
                        if (containsColor) {
                            player.playSound(SoundEvents.BREWING_STAND_BREW, 1.0f, 1.0f);
                            this.sendUpdateToClient();
                        }
                    } else {
                        this.bag = ((ItemLittleBag)this.tool.get().getItem()).getInventory(this.tool.get());
                    }
                }
                this.saveBagInventory();
            }
        });
        right.add((GuiControl)inputInventory);
        int colorStorage = LittleTiles.CONFIG.general.bag.colorStorage;
        right.add((GuiControl)new GuiColorProgressBar("black", unit.black, colorStorage, Color.BLACK));
        right.add((GuiControl)new GuiColorProgressBar("cyan", unit.cyan, colorStorage, Color.CYAN));
        right.add((GuiControl)new GuiColorProgressBar("magenta", unit.magenta, colorStorage, Color.MAGENTA));
        right.add((GuiControl)new GuiColorProgressBar("yellow", unit.yellow, colorStorage, Color.YELLOW));
        this.bag = ((ItemLittleBag)this.tool.get().getItem()).getInventory(this.tool.get());
        this.bagInventory = new SimpleContainer(LittleTiles.CONFIG.general.bag.inventorySize);
        this.bagInventoryGui = new GuiInventoryGrid(this.name, (Container)this.bagInventory, LittleTiles.CONFIG.general.bag.inventoryWidth, LittleTiles.CONFIG.general.bag.inventoryHeight, (c, i) -> new BagSlot((Container)c, (int)i));
        left.add((GuiControl)this.bagInventoryGui);
        this.add((GuiControl)this.addInventory((GuiInventoryGrid)new GuiPlayerInventoryGrid(this.getPlayer())).disableSlot(this.tool.index));
        this.addInventory(inputInventory);
        this.addInventory(this.bagInventoryGui);
    }

    public void load() {
        this.bag = ((ItemLittleBag)this.tool.get().getItem()).getInventory(this.tool.get());
        ColorIngredient unit = this.bag.get(ColorIngredient.class);
        ((GuiColorProgressBar)this.get((String)"black", GuiColorProgressBar.class)).pos = unit.black;
        ((GuiColorProgressBar)this.get((String)"cyan", GuiColorProgressBar.class)).pos = unit.cyan;
        ((GuiColorProgressBar)this.get((String)"magenta", GuiColorProgressBar.class)).pos = unit.magenta;
        ((GuiColorProgressBar)this.get((String)"yellow", GuiColorProgressBar.class)).pos = unit.yellow;
        this.clearItemCache();
    }

    public void clearItemCache() {
        for (int i = 0; i < this.bagInventoryGui.inventorySize(); ++i) {
            ((BagSlot)this.bagInventoryGui.getSlot((int)i).slot).resetCache();
        }
    }

    public boolean isExpandableX() {
        return false;
    }

    public boolean isExpandableY() {
        return false;
    }

    public void saveBagInventory() {
        ((ItemLittleBag)this.tool.get().getItem()).setInventory(this.tool.get(), this.bag, null);
    }

    @Override
    public void closed() {
        super.closed();
        ItemStack stack = this.input.getItem(0);
        if (!stack.isEmpty()) {
            this.getPlayer().drop(stack, true);
        }
    }

    @Override
    public boolean saveConfiguration(PatchedDataComponentMap data) {
        return false;
    }

    public Iterable<IGuiInventory> inventoriesToInsert() {
        return this.inventories;
    }

    public Iterable<IGuiInventory> inventoriesToExract() {
        return this.inventoriesInv;
    }

    public class BagSlot
    extends Slot {
        private ItemStack cache;
        private boolean full;

        public BagSlot(Container container, int index) {
            super(container, index, 0, 0);
        }

        public void resetCache() {
            this.cache = null;
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public BlockIngredientEntry getEntry() {
            List<BlockIngredientEntry> entries = GuiBag.this.bag.get(BlockIngredient.class).getContent();
            if (entries.size() > this.getSlotIndex()) {
                return entries.get(this.getSlotIndex());
            }
            return null;
        }

        public ItemStack getItem() {
            if (this.cache == null) {
                BlockIngredientEntry entry = this.getEntry();
                if (entry == null || entry.isEmpty()) {
                    this.cache = ItemStack.EMPTY;
                    this.full = false;
                } else {
                    this.cache = ItemBlockIngredient.of(entry);
                    this.cache.setCount(Math.max(1, (int)entry.value));
                    this.full = entry.value >= 1.0;
                }
            }
            return this.cache;
        }

        public ItemStack remove(int count) {
            ItemStack taken;
            BlockIngredientEntry entry = this.getEntry();
            if (entry == null) {
                return ItemStack.EMPTY;
            }
            if (this.full) {
                taken = entry.getBlockStack();
                taken.setCount(Math.min(count, (int)entry.value));
                entry.value -= (double)taken.getCount();
            } else {
                taken = this.cache.copy();
                taken.set(LittleTilesRegistry.BLOCK_INGREDIENT_ENTRY, (Object)entry.copy());
                entry.value = 0.0;
            }
            if (entry.isEmpty()) {
                GuiBag.this.bag.get(BlockIngredient.class).getContent().remove(this.getSlotIndex());
            }
            this.cache = null;
            GuiBag.this.saveBagInventory();
            GuiBag.this.clearItemCache();
            return taken;
        }
    }
}

