/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.handler;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.littletiles.common.level.handler.LevelHandler;

public class LevelHandlers<T extends LevelHandler> {
    protected final Function<Level, T> factory;
    private HashMap<Level, T> handlers = new HashMap();

    public static boolean isInvalidLevel(LevelAccessor level) {
        return level instanceof IOrientatedLevel;
    }

    public LevelHandlers() {
        this.factory = this.createFactory();
        NeoForge.EVENT_BUS.addListener(this::unloadEvent);
    }

    public LevelHandlers(Function<Level, T> factory) {
        this.factory = factory;
        NeoForge.EVENT_BUS.addListener(this::unloadEvent);
    }

    protected Function<Level, T> createFactory() {
        return null;
    }

    public Iterable<T> handlers(boolean client) {
        return new FilterIterator(this.handlers.values(), x -> x.level.isClientSide == client);
    }

    public Iterable<T> handlers() {
        return this.handlers.values();
    }

    public T getWithoutCreate(Level level) {
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            level = sub.getRealLevel();
        }
        return (T)((LevelHandler)this.handlers.get(level));
    }

    public T get(Level level) {
        LevelHandler handler;
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            level = sub.getRealLevel();
        }
        if ((handler = (LevelHandler)this.handlers.get(level)) == null) {
            handler = (LevelHandler)this.factory.apply(level);
            if (handler == null) {
                return null;
            }
            this.handlers.put(level, handler);
        }
        return (T)handler;
    }

    public void unloadEvent(LevelEvent.Unload event) {
        if (LevelHandlers.isInvalidLevel(event.getLevel())) {
            return;
        }
        LevelHandler handler = (LevelHandler)this.handlers.remove(event.getLevel());
        if (handler != null) {
            this.unloadHandler(handler);
        }
    }

    protected void unloadHandler(T handler) {
        ((LevelHandler)handler).unload();
    }
}

