/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesSimple;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;

public class PlacementResult {
    public final BlockPos pos;
    public final LittleGroup placedPreviews;
    public final LittleBoxes placedBoxes;
    private BlockPos lastPos = null;
    public final List<BETiles> blocks = new ArrayList<BETiles>();
    public LittleStructure parentStructure;
    public final LittleIngredients ingredients;

    public PlacementResult(BlockPos pos) {
        this.pos = pos;
        this.placedPreviews = new LittleGroup();
        this.placedBoxes = new LittleBoxesSimple(pos, LittleGrid.MIN);
        this.ingredients = new LittleIngredients();
    }

    public void addPlacedTile(LittleStructureType type, ParentCollection parent, LittleTile tile) {
        if (this.lastPos == null || !this.lastPos.equals((Object)parent.getPos())) {
            this.lastPos = parent.getPos();
            this.blocks.add(parent.getBE());
        }
        this.placedPreviews.add(parent.getGrid(), (LittleElement)tile, tile.copy());
        this.placedBoxes.addBoxes(parent, tile);
        if (type == null || type.tilesCountAsIngredient()) {
            this.ingredients.add(LittleAction.getIngredients((IParentCollection)parent, tile));
        }
    }

    public void broadcastChangesImmediately(ServerLevel level) {
        HashMap<LevelChunk, ChunkHolder> map = new HashMap<LevelChunk, ChunkHolder>();
        for (BETiles bETiles : this.blocks) {
            LevelChunk l;
            ChunkAccess chunk = level.getChunk(bETiles.getBlockPos());
            if (!(chunk instanceof LevelChunk) || map.containsKey(l = (LevelChunk)chunk)) continue;
            map.put(l, level.getChunkSource().chunkMap.getVisibleChunkIfPresent(l.getPos().toLong()));
        }
        for (Map.Entry entry : map.entrySet()) {
            ((ChunkHolder)entry.getValue()).broadcastChanges((LevelChunk)entry.getKey());
        }
    }
}

