/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.animation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.registry.exception.RegistryException;
import team.creative.creativecore.common.util.type.list.MarkIterator;
import team.creative.creativecore.common.util.type.list.MarkList;
import team.creative.littletiles.common.structure.animation.PhysicalPart;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.animation.context.AnimationContext;
import team.creative.littletiles.common.structure.animation.curve.ValueCurve;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;

public class AnimationTimeline {
    public final int duration;
    private int tick;
    private int eventIndex = 0;
    private MarkList<AnimationEventEntry> events;
    protected PhysicalState start;
    protected PhysicalState end;
    protected ValueCurve<Vec1d> offX = ValueCurve.ONE_EMPTY;
    protected ValueCurve<Vec1d> offY = ValueCurve.ONE_EMPTY;
    protected ValueCurve<Vec1d> offZ = ValueCurve.ONE_EMPTY;
    protected ValueCurve<Vec1d> rotX = ValueCurve.ONE_EMPTY;
    protected ValueCurve<Vec1d> rotY = ValueCurve.ONE_EMPTY;
    protected ValueCurve<Vec1d> rotZ = ValueCurve.ONE_EMPTY;

    public AnimationTimeline(CompoundTag nbt) {
        this.duration = nbt.getInt("d");
        this.tick = nbt.getInt("t");
        this.eventIndex = nbt.getInt("eI");
        for (PhysicalPart part : PhysicalPart.values()) {
            if (!nbt.contains(part.name())) continue;
            this.set(part, ValueCurve.load(nbt.getCompound(part.name())));
        }
        ArrayList<AnimationEventEntry> entries = new ArrayList<AnimationEventEntry>();
        ListTag list = nbt.getList("e", 10);
        for (int i = 0; i < list.size(); ++i) {
            try {
                entries.add(new AnimationEventEntry(list.getCompound(i)));
                continue;
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        this.events = new MarkList(entries);
    }

    public AnimationTimeline(int duration) {
        this.duration = duration;
        this.tick = 0;
        this.events = MarkList.EMPTY;
    }

    public AnimationTimeline(int duration, List<AnimationEventEntry> events) {
        this.duration = duration;
        this.tick = 0;
        ArrayList<AnimationEventEntry> tempList = new ArrayList<AnimationEventEntry>(events);
        Collections.sort(tempList);
        this.events = new MarkList(tempList);
    }

    public boolean isAligned() {
        return this.offX == ValueCurve.ONE_EMPTY && this.offY == ValueCurve.ONE_EMPTY && this.offZ == ValueCurve.ONE_EMPTY && this.rotX == ValueCurve.ONE_EMPTY && this.rotY == ValueCurve.ONE_EMPTY && this.rotZ == ValueCurve.ONE_EMPTY;
    }

    public ValueCurve<Vec1d> get(PhysicalPart part) {
        return switch (part) {
            default -> throw new MatchException(null, null);
            case PhysicalPart.OFFX -> this.offX;
            case PhysicalPart.OFFY -> this.offY;
            case PhysicalPart.OFFZ -> this.offZ;
            case PhysicalPart.ROTX -> this.rotX;
            case PhysicalPart.ROTY -> this.rotY;
            case PhysicalPart.ROTZ -> this.rotZ;
        };
    }

    public void set(PhysicalPart part, ValueCurve<Vec1d> value) {
        switch (part) {
            case OFFX: {
                this.offX = value;
                break;
            }
            case OFFY: {
                this.offY = value;
                break;
            }
            case OFFZ: {
                this.offZ = value;
                break;
            }
            case ROTX: {
                this.rotX = value;
                break;
            }
            case ROTY: {
                this.rotY = value;
                break;
            }
            case ROTZ: {
                this.rotZ = value;
            }
        }
    }

    public void start(PhysicalState start, PhysicalState end, Supplier<ValueCurve<Vec1d>> curve1d) {
        this.start = start;
        this.end = end;
        this.tick = 0;
        this.eventIndex = 0;
        this.events.clear();
        for (PhysicalPart part : PhysicalPart.values()) {
            ValueCurve<Vec1d> curve = this.get(part);
            double s = start.get(part);
            double e = end.get(part);
            if (curve.isEmpty() && s == 0.0 && e == 0.0) continue;
            if (!curve.modifiable()) {
                curve = curve1d.get();
                this.set(part, curve);
            }
            curve.start(new Vec1d(s), new Vec1d(e), this.duration);
        }
    }

    protected void tickState(int tick, PhysicalState state) {
        PhysicalPart[] physicalPartArray = PhysicalPart.values();
        int n = physicalPartArray.length;
        for (int i = 0; i < n; ++i) {
            PhysicalPart part;
            ValueCurve<Vec1d> curve = this.get(part = physicalPartArray[i]);
            state.set(part, curve.isEmpty() ? 0.0 : this.get((PhysicalPart)part).value((int)tick).x);
        }
    }

    public void setStateAtTick(int tick, PhysicalState state, AnimationContext context) {
        this.tickState(tick, state);
        for (AnimationEventEntry entry : this.events.allIgnoreMark()) {
            entry.setAtTick(tick, context);
        }
    }

    public boolean tick(PhysicalState state, AnimationContext context) {
        if (this.tick <= this.duration) {
            ++this.tick;
        }
        this.tickState(this.tick, state);
        if (this.tick > this.duration && this.events.isEmpty()) {
            return true;
        }
        while (this.eventIndex < this.events.sizeIgnoreMark() && ((AnimationEventEntry)this.events.getIgnoreMark((int)this.eventIndex)).start <= this.tick) {
            AnimationEventEntry entry = (AnimationEventEntry)this.events.getIgnoreMark(this.eventIndex);
            entry.start(context);
            ++this.eventIndex;
        }
        MarkIterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            AnimationEventEntry entry = (AnimationEventEntry)iterator.next();
            if (entry.active() && entry.isDone(this.tick, context)) {
                entry.end();
            }
            if (entry.active()) continue;
            iterator.mark();
        }
        return this.tick > this.duration && this.events.isEmpty();
    }

    public void end() {
        for (PhysicalPart part : PhysicalPart.values()) {
            this.get(part).end();
        }
        this.end = null;
        this.start = null;
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("d", this.duration);
        nbt.putInt("t", this.tick);
        nbt.putInt("eI", this.eventIndex);
        ListTag list = new ListTag();
        for (AnimationEventEntry entry : this.events.allIgnoreMark()) {
            list.add((Object)entry.save());
        }
        nbt.put("e", (Tag)list);
        for (PhysicalPart part : PhysicalPart.values()) {
            ValueCurve<Vec1d> curve = this.get(part);
            if (curve.isEmpty()) continue;
            nbt.put(part.name(), (Tag)curve.save());
        }
        return nbt;
    }

    public void transform(IntMatrix3c matrix) {
        ValueCurve<Vec1d> tempX = this.offX;
        ValueCurve<Vec1d> tempY = this.offY;
        ValueCurve<Vec1d> tempZ = this.offZ;
        this.offX = (ValueCurve)matrix.getX(tempX, tempY, tempZ);
        this.offY = (ValueCurve)matrix.getY(tempX, tempY, tempZ);
        this.offZ = (ValueCurve)matrix.getZ(tempX, tempY, tempZ);
        if (matrix.invertedX()) {
            this.offX.invert();
        }
        if (matrix.invertedY()) {
            this.offY.invert();
        }
        if (matrix.invertedZ()) {
            this.offZ.invert();
        }
        tempX = this.rotX;
        tempY = this.rotY;
        tempZ = this.rotZ;
        this.rotX = (ValueCurve)matrix.getX(tempX, tempY, tempZ);
        this.rotY = (ValueCurve)matrix.getY(tempX, tempY, tempZ);
        this.rotZ = (ValueCurve)matrix.getZ(tempX, tempY, tempZ);
        if (matrix.invertedX()) {
            this.rotX.invert();
        }
        if (matrix.invertedY()) {
            this.rotY.invert();
        }
        if (matrix.invertedZ()) {
            this.rotZ.invert();
        }
    }

    public AnimationTimeline copy() {
        ArrayList<AnimationEventEntry> events = new ArrayList<AnimationEventEntry>();
        for (AnimationEventEntry entry : this.events.allIgnoreMark()) {
            events.add(entry.copy());
        }
        AnimationTimeline timeline = new AnimationTimeline(this.duration, events);
        timeline.start = this.start != null ? this.start.copy() : null;
        timeline.end = this.end != null ? this.end.copy() : null;
        for (PhysicalPart part : PhysicalPart.values()) {
            timeline.set(part, this.get(part).copy());
        }
        return timeline;
    }

    public void reverse(AnimationContext context) {
        for (PhysicalPart part : PhysicalPart.values()) {
            this.get(part).reverse(this.duration);
        }
        PhysicalState beginning = this.start;
        this.start = this.end;
        this.end = beginning;
        ArrayList<AnimationEventEntry> newEvents = new ArrayList<AnimationEventEntry>();
        for (AnimationEventEntry entry : this.events.allIgnoreMark()) {
            newEvents.add(new AnimationEventEntry(entry.reverseTick(this.duration, context), entry.event));
        }
        Collections.sort(newEvents);
        this.events = new MarkList(newEvents);
    }

    public Iterable<AnimationEventEntry> allEvents() {
        return this.events.allIgnoreMark();
    }

    public int getTick() {
        return this.tick;
    }

    public static class AnimationEventEntry
    implements Comparable<AnimationEventEntry> {
        private AnimationEvent event;
        public final int start;
        protected boolean active = false;

        AnimationEventEntry(CompoundTag nbt) throws RegistryException {
            this.start = nbt.getInt("t");
            this.event = (AnimationEvent)AnimationEvent.REGISTRY.create(nbt.getString("id"), new Object[]{nbt.get("e")});
            this.active = nbt.getBoolean("a");
        }

        public AnimationEventEntry(int tick, AnimationEvent event) {
            this.start = tick;
            this.event = event;
        }

        public boolean active() {
            return this.active;
        }

        public void start(AnimationContext context) {
            this.active = true;
            this.event.start(context);
        }

        public void setAtTick(int current, AnimationContext context) {
            if (current == this.start) {
                this.event.start(context);
            }
        }

        public boolean isDone(int current, AnimationContext context) {
            return this.event.isDone(current - this.start, context);
        }

        public int reverseTick(int duration, AnimationContext context) {
            return this.event.reverseTick(this.start, duration, context);
        }

        public void end() {
            this.active = false;
        }

        @Override
        public int compareTo(AnimationEventEntry o) {
            return Integer.compare(this.start, o.start);
        }

        public CompoundTag save() {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("t", this.start);
            nbt.putBoolean("a", this.active);
            nbt.putString("id", AnimationEvent.REGISTRY.getId((Object)this.event));
            nbt.put("e", this.event.save());
            return nbt;
        }

        public AnimationEventEntry copy() {
            return new AnimationEventEntry(this.start, this.event.copy());
        }

        public AnimationEvent getEvent() {
            return this.event;
        }
    }
}

