/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.sodium;

import java.nio.ByteBuffer;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.BakedChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import team.creative.littletiles.client.mod.sodium.buffer.SodiumBufferUploader;
import team.creative.littletiles.mixin.sodium.ChunkMeshBufferBuilderAccessor;

@Mixin(value={BakedChunkModelBuilder.class})
public class BakedChunkModelBuilderMixin
implements SodiumBufferUploader {
    @Unique
    private TranslucentGeometryCollector collector;

    @Override
    public int uploadIndex() {
        return this.uploadIndex(ModelQuadFacing.UNASSIGNED.ordinal());
    }

    @Override
    public void upload(ByteBuffer buffer) {
        this.upload(ModelQuadFacing.UNASSIGNED.ordinal(), buffer);
    }

    @Override
    public boolean hasFacingSupport() {
        return true;
    }

    @Override
    public int uploadIndex(int facing) {
        ChunkMeshBufferBuilderAccessor vertex = (ChunkMeshBufferBuilderAccessor)((ChunkModelBuilder)this).getVertexBuffer(ModelQuadFacing.VALUES[facing]);
        return vertex.getVertexCount() * vertex.getStride();
    }

    @Override
    public void upload(int facing, ByteBuffer buffer) {
        int vertexCount;
        ChunkMeshBufferBuilderAccessor vertex = (ChunkMeshBufferBuilderAccessor)((ChunkModelBuilder)this).getVertexBuffer(ModelQuadFacing.VALUES[facing]);
        int vertexStart = vertex.getVertexCount();
        if (vertexStart + (vertexCount = buffer.limit() / vertex.getStride()) >= vertex.getVertexCapacity()) {
            vertex.callGrow(vertexCount);
        }
        ByteBuffer data = vertex.getBuffer();
        int index = vertex.getVertexCount() * vertex.getStride();
        long address = MemoryUtil.memAddress((ByteBuffer)data, (int)index);
        long insertAddress = MemoryUtil.memAddress((ByteBuffer)buffer);
        MemoryUtil.memCopy((long)insertAddress, (long)address, (long)buffer.capacity());
        vertex.setVertexCount(vertex.getVertexCount() + vertexCount);
    }

    @Override
    public void addTexture(TextureAtlasSprite texture) {
        ((ChunkModelBuilder)this).addSprite(texture);
    }

    @Override
    public boolean isSorted() {
        return this.collector != null;
    }

    @Override
    public TranslucentGeometryCollector getTranslucentCollector() {
        return this.collector;
    }

    @Override
    public void setTranslucentCollector(TranslucentGeometryCollector collector) {
        this.collector = collector;
    }
}

