/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleActionActivated;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.math.vec.LittleHitResult;
import team.creative.littletiles.server.action.interact.LittleInteractionHandlerServer;
import team.creative.littletiles.server.level.handler.LittleActionHandlerServer;
import team.creative.littletiles.server.level.util.NeighborUpdateOrganizer;

public class LittleTilesServer {
    public static NeighborUpdateOrganizer NEIGHBOR;
    public static LittleInteractionHandlerServer INTERACTION;

    public static void init(FMLCommonSetupEvent event) {
        NEIGHBOR = new NeighborUpdateOrganizer();
        INTERACTION = new LittleInteractionHandlerServer();
        NeoForge.EVENT_BUS.addListener(LittleActionHandlerServer::playerLoggedIn);
    }

    public static boolean playerRightClickServer(ServerPlayer player, Vec3 pos, Vec3 look) {
        AABB box = new AABB(pos, look);
        Level level = player.level();
        LittleEntity pointedEntity = null;
        LittleAnimationHandler handler = (LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(level);
        BlockHitResult result = level.clip(new ClipContext(pos, look, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double distance = result != null ? pos.distanceTo(result.getLocation()) : 0.0;
        for (LittleEntity animation : handler.find(box)) {
            LittleHitResult tempResult = handler.getHit(pos, look, pos.distanceTo(look));
            if (!tempResult.isBlock()) continue;
            double tempDistance = pos.distanceTo(animation.getOrigin().transformPointToWorld(tempResult.asBlockHit().getLocation()));
            if (result != null && !(tempDistance < distance)) continue;
            result = tempResult.asBlockHit();
            distance = tempDistance;
            pointedEntity = animation;
        }
        if (pointedEntity == null) {
            if (result instanceof BlockHitResult) {
                BlockState state = level.getBlockState(result.getBlockPos());
                if (state.getBlock() instanceof BlockTile) {
                    return LittleActionHandlerServer.execute(player, new LittleActionActivated(level, result.getBlockPos(), pos, look, false)).consumesAction();
                }
                return false;
            }
        } else {
            return LittleActionHandlerServer.execute(player, new LittleActionActivated((Level)pointedEntity.getSubLevel(), result.getBlockPos(), pos, look, false)).consumesAction();
        }
        return false;
    }
}

