/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles;

import com.mojang.datafixers.DSL;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import team.creative.littletiles.common.block.entity.BESignalConverter;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.entity.BETilesRendered;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.mc.BlockArrow;
import team.creative.littletiles.common.block.mc.BlockFlowingLava;
import team.creative.littletiles.common.block.mc.BlockFlowingWater;
import team.creative.littletiles.common.block.mc.BlockLava;
import team.creative.littletiles.common.block.mc.BlockSignalConverter;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.block.mc.BlockWater;
import team.creative.littletiles.common.entity.EntitySit;
import team.creative.littletiles.common.entity.PrimedSizedTnt;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.level.LittleLevelEntity;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.item.ItemBlockIngredient;
import team.creative.littletiles.common.item.ItemColorIngredient;
import team.creative.littletiles.common.item.ItemLittleBag;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.item.ItemLittleChisel;
import team.creative.littletiles.common.item.ItemLittleGlove;
import team.creative.littletiles.common.item.ItemLittleHammer;
import team.creative.littletiles.common.item.ItemLittlePaintBrush;
import team.creative.littletiles.common.item.ItemLittleSaw;
import team.creative.littletiles.common.item.ItemLittleScrewdriver;
import team.creative.littletiles.common.item.ItemLittleWrench;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.item.ItemPremadeStructure;
import team.creative.littletiles.common.item.component.MatrixDataComponent;
import team.creative.littletiles.common.item.component.SelectionComponent;
import team.creative.littletiles.common.item.component.TileFilterComponent;
import team.creative.littletiles.common.placement.shape.LittleShapeInstance;
import team.creative.littletiles.common.recipe.PremadeShapedRecipeSerializer;
import team.creative.littletiles.common.recipe.StructureIngredient;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadeRegistry;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class LittleTilesRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"littletiles");
    public static final Holder<Item> HAMMER = ITEMS.register("hammer", () -> new ItemLittleHammer());
    public static final Holder<Item> BLUEPRINT = ITEMS.register("blueprint", () -> new ItemLittleBlueprint());
    public static final Holder<Item> ITEM_TILES = ITEMS.register("multi_tiles", () -> new ItemMultiTiles());
    public static final Holder<Item> SAW = ITEMS.register("saw", () -> new ItemLittleSaw());
    public static final Holder<Item> BAG = ITEMS.register("bag", () -> new ItemLittleBag());
    public static final Holder<Item> WRENCH = ITEMS.register("wrench", () -> new ItemLittleWrench());
    public static final Holder<Item> SCREWDRIVER = ITEMS.register("screwdriver", () -> new ItemLittleScrewdriver());
    public static final Holder<Item> CHISEL = ITEMS.register("chisel", () -> new ItemLittleChisel());
    public static final Holder<Item> PAINT_BRUSH = ITEMS.register("paint_brush", () -> new ItemLittlePaintBrush());
    public static final Holder<Item> GLOVE = ITEMS.register("glove", () -> new ItemLittleGlove());
    public static final Holder<Item> PREMADE = ITEMS.register("premade", () -> new ItemPremadeStructure());
    public static final Holder<Item> BLOCK_INGREDIENT = ITEMS.register("blockingredient", () -> new ItemBlockIngredient());
    public static final Holder<Item> BLACK_COLOR = ITEMS.register("bottle_black", () -> new ItemColorIngredient(ItemColorIngredient.ColorIngredientType.black));
    public static final Holder<Item> CYAN_COLOR = ITEMS.register("bottle_cyan", () -> new ItemColorIngredient(ItemColorIngredient.ColorIngredientType.cyan));
    public static final Holder<Item> MAGENTA_COLOR = ITEMS.register("bottle_magenta", () -> new ItemColorIngredient(ItemColorIngredient.ColorIngredientType.magenta));
    public static final Holder<Item> YELLOW_COLOR = ITEMS.register("bottle_yellow", () -> new ItemColorIngredient(ItemColorIngredient.ColorIngredientType.yellow));
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"littletiles");
    private static final StreamCodec<ByteBuf, CustomData> CUSTOM_DATA_STREAM_CODEC = ByteBufCodecs.TRUSTED_COMPOUND_TAG.map(x -> CustomData.of((CompoundTag)x), x -> x.getUnsafe());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CustomData>> DATA = DATA_COMPONENTS.register("tool_config", (T x) -> DataComponentType.builder().persistent(CustomData.CODEC).networkSynchronized(CUSTOM_DATA_STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> COLOR_AMOUNT = DATA_COMPONENTS.register("color_amount", (T x) -> DataComponentType.builder().persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> COLOR = DATA_COMPONENTS.register("color", (T x) -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> COLOR_SECONDARY = DATA_COMPONENTS.register("color_secondary", (T x) -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<BlockIngredientEntry>> BLOCK_INGREDIENT_ENTRY = DATA_COMPONENTS.register("block_ingredient", (T x) -> DataComponentType.builder().persistent(BlockIngredientEntry.CODEC).networkSynchronized(BlockIngredientEntry.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<MatrixDataComponent>> MATRIX = DATA_COMPONENTS.register("matrix", (T x) -> DataComponentType.builder().persistent(MatrixDataComponent.CODEC).networkSynchronized(MatrixDataComponent.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<LittleElement>> ELEMENT = DATA_COMPONENTS.register("element", (T x) -> DataComponentType.builder().persistent(LittleElement.CODEC).networkSynchronized(LittleElement.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<LittleShapeInstance>> SHAPE = DATA_COMPONENTS.register("shape", (T x) -> DataComponentType.builder().persistent(LittleShapeInstance.CODEC).networkSynchronized(LittleShapeInstance.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<TileFilterComponent>> FILTER = DATA_COMPONENTS.register("filter", (T x) -> DataComponentType.builder().persistent(TileFilterComponent.CODEC).networkSynchronized(TileFilterComponent.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SelectionComponent>> SELECTION = DATA_COMPONENTS.register("selection", (T x) -> DataComponentType.builder().persistent(SelectionComponent.CODEC).networkSynchronized(SelectionComponent.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<BlockPos>> FIRST_POS = DATA_COMPONENTS.register("pos1", (T x) -> DataComponentType.builder().persistent(BlockPos.CODEC).networkSynchronized(BlockPos.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<BlockPos>> SECOND_POS = DATA_COMPONENTS.register("pos2", (T x) -> DataComponentType.builder().persistent(BlockPos.CODEC).networkSynchronized(BlockPos.STREAM_CODEC).build());
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"littletiles");
    public static final Holder<Block> BLOCK_TILES = BLOCKS.register("tiles", () -> new BlockTile(false, false));
    public static final Holder<Block> BLOCK_TILES_TICKING = BLOCKS.register("tiles_ticking", () -> new BlockTile(true, false));
    public static final Holder<Block> BLOCK_TILES_RENDERED = BLOCKS.register("tiles_rendered", () -> new BlockTile(false, true));
    public static final Holder<Block> BLOCK_TILES_TICKING_RENDERED = BLOCKS.register("tiles_ticking_rendered", () -> new BlockTile(true, true));
    public static final Holder<Block> CLEAN = LittleTilesRegistry.register("colored_clean", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> FLOOR = LittleTilesRegistry.register("colored_floor", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> GRAINY_BIG = LittleTilesRegistry.register("colored_grainy_big", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> GRAINY = LittleTilesRegistry.register("colored_grainy", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> GRAINY_LOW = LittleTilesRegistry.register("colored_grainy_low", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> BRICK = LittleTilesRegistry.register("colored_brick", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> BRICK_BIG = LittleTilesRegistry.register("colored_brick_big", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> BORDERED = LittleTilesRegistry.register("colored_bordered", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> CHISELED = LittleTilesRegistry.register("colored_chiseled", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> BROKEN_BRICK_BIG = LittleTilesRegistry.register("colored_broken_brick_big", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> CLAY = LittleTilesRegistry.register("colored_clay", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> STRIPS = LittleTilesRegistry.register("colored_strips", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> GRAVEL = LittleTilesRegistry.register("colored_gravel", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> SAND = LittleTilesRegistry.register("colored_sand", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> STONE = LittleTilesRegistry.register("colored_stone", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> CORK = LittleTilesRegistry.register("colored_cork", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW)));
    public static final Holder<Block> WATER = LittleTilesRegistry.register("colored_water", () -> new BlockWater(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.COLOR_BLUE).noCollission()));
    public static final Holder<Block> LAVA = LittleTilesRegistry.register("colored_lava", () -> new BlockLava(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.COLOR_RED).noCollission()));
    public static final Holder<Block> WHITE_LAVA = LittleTilesRegistry.register("colored_white_lava", () -> new BlockLava(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).mapColor(MapColor.SNOW).noCollission().lightLevel(x -> 15)));
    public static final Holder<Block> STORAGE_BLOCK = LittleTilesRegistry.register("storage", () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).destroyTime(1.5f).strength(1.5f)));
    public static final Holder<Block> FLOWING_WATER = BLOCKS.register("colored_water_flowing", () -> new BlockFlowingWater(WATER));
    public static final Holder<Block> FLOWING_LAVA = BLOCKS.register("colored_lava_flowing", () -> new BlockFlowingLava(LAVA));
    public static final Holder<Block> WHITE_FLOWING_LAVA = BLOCKS.register("colored_white_lava_flowing", () -> new BlockFlowingLava(WHITE_LAVA));
    public static final Holder<Block> SINGLE_CABLE = BLOCKS.register("cable_single", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().strength(1.5f, 6.0f).sound(SoundType.WOOD)));
    public static final Holder<Block> INPUT_ARROW = BLOCKS.register("arrow_input", () -> new BlockArrow());
    public static final Holder<Block> OUTPUT_ARROW = BLOCKS.register("arrow_output", () -> new BlockArrow());
    public static final Holder<Block> SIGNAL_CONVERTER = LittleTilesRegistry.register("signal_converter", () -> new BlockSignalConverter());
    public static final Holder<Block> MISSING = LittleTilesRegistry.register("missing", () -> new Block(BlockBehaviour.Properties.of()));
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"littletiles");
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BETiles>> BE_TILES_TYPE = LittleTilesRegistry.registerBlockEntity("tiles", () -> BlockEntityType.Builder.of(BETiles::new, (Block[])new Block[]{(Block)BLOCK_TILES.value(), (Block)BLOCK_TILES_TICKING.value()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BETilesRendered>> BE_TILES_TYPE_RENDERED = LittleTilesRegistry.registerBlockEntity("tiles_rendered", () -> BlockEntityType.Builder.of(BETilesRendered::new, (Block[])new Block[]{(Block)BLOCK_TILES_RENDERED.value(), (Block)BLOCK_TILES_TICKING_RENDERED.value()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BESignalConverter>> BE_SIGNALCONVERTER_TYPE = LittleTilesRegistry.registerBlockEntity("converter", () -> BlockEntityType.Builder.of(BESignalConverter::new, (Block[])new Block[]{(Block)SIGNAL_CONVERTER.value()}));
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"littletiles");
    public static final DeferredHolder<EntityType<?>, EntityType<PrimedSizedTnt>> SIZED_TNT_TYPE = ENTITIES.register("primed_size_tnt", () -> EntityType.Builder.of(PrimedSizedTnt::new, (MobCategory)MobCategory.MISC).build("primed_size_tnt"));
    public static final DeferredHolder<EntityType<?>, EntityType<EntitySit>> SIT_TYPE = ENTITIES.register("sit", () -> EntityType.Builder.of(EntitySit::new, (MobCategory)MobCategory.MISC).build("sit"));
    public static final DeferredHolder<EntityType<?>, EntityType<LittleAnimationEntity>> ENTITY_ANIMATION = ENTITIES.register("litte_animation", () -> EntityType.Builder.of(LittleAnimationEntity::new, (MobCategory)MobCategory.MISC).build("litte_animation"));
    public static final DeferredHolder<EntityType<?>, EntityType<LittleLevelEntity>> ENTITY_LEVEL = ENTITIES.register("little_level", () -> EntityType.Builder.of(LittleLevelEntity::new, (MobCategory)MobCategory.MISC).build("little_level"));
    public static final ResourceKey FAKE_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.tryBuild((String)"littletiles", (String)"fake"));
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"littletiles");
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<? extends CraftingRecipe>> PREMADE_RECIPES = RECIPE_SERIALIZERS.register("crafting_shaped_premade", PremadeShapedRecipeSerializer::new);
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"littletiles");
    public static final Holder<CreativeModeTab> TAB = CREATIVE_TABS.register("items", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)HAMMER.value())).title((Component)Component.translatable((String)"creative_tab.littletiles")).displayItems((features, output) -> {
        ItemMultiTiles.collectExamples(output);
        for (LittleStructurePremade.LittlePremadeType entry : LittlePremadeRegistry.types()) {
            if (!entry.showInCreativeTab || entry.hasCustomTab()) continue;
            output.accept(entry.createItemStack());
        }
        output.accept((ItemLike)HAMMER.value());
        output.accept((ItemLike)CHISEL.value());
        output.accept((ItemLike)BLUEPRINT.value());
        output.accept((ItemLike)BAG.value());
        output.accept((ItemLike)GLOVE.value());
        output.accept((ItemLike)PAINT_BRUSH.value());
        output.accept((ItemLike)SAW.value());
        output.accept((ItemLike)SCREWDRIVER.value());
        output.accept((ItemLike)WRENCH.value());
        output.accept((ItemLike)SIGNAL_CONVERTER.value());
        output.accept((ItemLike)STORAGE_BLOCK.value());
        output.accept((ItemLike)CLEAN.value());
        output.accept((ItemLike)FLOOR.value());
        output.accept((ItemLike)GRAINY_BIG.value());
        output.accept((ItemLike)GRAINY.value());
        output.accept((ItemLike)GRAINY_LOW.value());
        output.accept((ItemLike)BRICK.value());
        output.accept((ItemLike)BRICK_BIG.value());
        output.accept((ItemLike)BORDERED.value());
        output.accept((ItemLike)CHISELED.value());
        output.accept((ItemLike)BROKEN_BRICK_BIG.value());
        output.accept((ItemLike)CLAY.value());
        output.accept((ItemLike)STRIPS.value());
        output.accept((ItemLike)GRAVEL.value());
        output.accept((ItemLike)SAND.value());
        output.accept((ItemLike)STONE.value());
        output.accept((ItemLike)CORK.value());
        output.accept((ItemLike)WATER.value());
        output.accept((ItemLike)LAVA.value());
        output.accept((ItemLike)WHITE_LAVA.value());
    }).build());
    public static final DeferredRegister<IngredientType<?>> INGREDIENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.INGREDIENT_TYPES, (String)"littletiles");
    public static final DeferredHolder<IngredientType<?>, IngredientType<StructureIngredient>> STRUCTURE_INGREDIENT_TYPE = INGREDIENT_TYPES.register("structure", () -> new IngredientType(StructureIngredient.CODEC));

    private static <T extends Block> DeferredHolder<Block, ? extends T> register(String name, Supplier<? extends T> sup) {
        DeferredHolder ret = BLOCKS.register(name, sup);
        ITEMS.register(name, () -> new BlockItem((Block)ret.value(), new Item.Properties()));
        return ret;
    }

    public static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> registerBlockEntity(String name, Supplier<BlockEntityType.Builder<T>> sup) {
        return BLOCK_ENTITIES.register(name, () -> ((BlockEntityType.Builder)sup.get()).build(Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)name)));
    }
}

