/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.client.level.LevelAwareHandler;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.exception.LittleActionException;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.math.vec.LittleHitResult;

public class PreviewRenderer
implements LevelAwareHandler {
    public static final ResourceLocation WHITE_TEXTURE = ResourceLocation.tryBuild((String)"littletiles", (String)"textures/preview.png");
    public static final Minecraft mc = Minecraft.getInstance();
    private ItemStack lastHeld = ItemStack.EMPTY;
    private Iterable<LittleTool> tools;

    public static void renderShape(PoseStack pose, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose posestack$pose = pose.last();
        shape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            float f = (float)(x2 - x1);
            float f1 = (float)(y2 - y1);
            float f2 = (float)(z2 - z1);
            float f3 = Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
            consumer.addVertex(posestack$pose.pose(), (float)(x1 + x), (float)(y1 + y), (float)(z1 + z)).setColor(red, green, blue, alpha).setNormal(posestack$pose, f /= f3, f1 /= f3, f2 /= f3);
            consumer.addVertex(posestack$pose.pose(), (float)(x2 + x), (float)(y2 + y), (float)(z2 + z)).setColor(red, green, blue, alpha).setNormal(posestack$pose, f, f1, f2);
        });
    }

    public PreviewRenderer() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public Iterable<LittleTool> tools() {
        return this.tools;
    }

    public void clearToolPreviews() {
        this.lastHeld = ItemStack.EMPTY;
        if (this.tools != null) {
            for (LittleTool p : this.tools) {
                p.removed();
            }
        }
        this.tools = null;
    }

    @Override
    public void unload() {
        this.clearToolPreviews();
    }

    @SubscribeEvent
    public void tick(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        if (PreviewRenderer.mc.player == null || PreviewRenderer.mc.screen instanceof IGuiParent) {
            return;
        }
        ClientLevel level = PreviewRenderer.mc.level;
        LocalPlayer player = PreviewRenderer.mc.player;
        ItemStack stack = player.getMainHandItem();
        PoseStack pose = new PoseStack();
        if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.lastHeld)) {
            this.clearToolPreviews();
            Item item = stack.getItem();
            if (item instanceof ILittleTool) {
                ILittleTool tool = (ILittleTool)item;
                this.tools = tool.tools(stack);
            } else {
                this.tools = null;
            }
            this.lastHeld = stack.copy();
        }
        if (!LittleAction.canPlace((Player)player) || PreviewRenderer.mc.options.hideGui) {
            this.processKeys((Level)level, (Player)player, stack, false);
            return;
        }
        if (this.tools != null) {
            BlockHitResult blockHit = this.blockHit();
            for (LittleTool t : this.tools) {
                t.stack = stack;
                t.tick((Level)level, (Player)player, blockHit);
            }
        }
        this.processKeys((Level)level, (Player)player, stack, true);
        if (this.tools != null) {
            Vec3 cam = PreviewRenderer.mc.gameRenderer.getMainCamera().getPosition();
            RenderSystem.enableBlend();
            for (LittleTool t : this.tools) {
                t.render((Level)level, (Player)player, pose, cam, false);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    private void processKeys(Level level, Player player, ItemStack stack, boolean execute) {
        ILittleTool t;
        Object gui;
        while (LittleTilesClient.KEY_UNDO.consumeClick()) {
            try {
                if (!execute || !LittleActionHandlerClient.canUseUndoOrRedo()) continue;
                LittleTilesClient.ACTION_HANDLER.undo();
            }
            catch (LittleActionException e) {
                LittleActionHandlerClient.handleException(e);
            }
        }
        while (LittleTilesClient.KEY_REDO.consumeClick()) {
            try {
                if (!execute || !LittleActionHandlerClient.canUseUndoOrRedo()) continue;
                LittleTilesClient.ACTION_HANDLER.redo();
            }
            catch (LittleActionException e) {
                LittleActionHandlerClient.handleException(e);
            }
        }
        while (LittleTilesClient.KEY_CONFIGURE.consumeClick()) {
            Item item = stack.getItem();
            if (!(item instanceof ILittleTool) || (gui = (t = (ILittleTool)item).getConfigure((Player)PreviewRenderer.mc.player, ContainerSlotView.mainHand((Player)PreviewRenderer.mc.player), false)) == null) continue;
            LittleTilesGuiRegistry.OPEN_CONFIG.open((Player)PreviewRenderer.mc.player);
        }
        while (LittleTilesClient.KEY_CONFIGURE_SECONDARY.consumeClick()) {
            gui = stack.getItem();
            if (!(gui instanceof ILittleTool) || (gui = (t = (ILittleTool)gui).getConfigure((Player)PreviewRenderer.mc.player, ContainerSlotView.mainHand((Player)PreviewRenderer.mc.player), true)) == null) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("second", true);
            LittleTilesGuiRegistry.OPEN_CONFIG.open(nbt, (Player)PreviewRenderer.mc.player);
        }
        for (KeyMapping key : LittleTilesClient.TOOL_KEYS) {
            while (key.consumeClick()) {
                if (!execute || this.tools == null) continue;
                for (LittleTool p : this.tools) {
                    if (p.keyPressed(level, player, key)) break;
                }
            }
        }
    }

    @SubscribeEvent
    public void drawNonHighlight(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        if (mc.getCameraEntity() instanceof Player && !PreviewRenderer.mc.options.hideGui && PreviewRenderer.mc.hitResult != null && PreviewRenderer.mc.hitResult.getType() == HitResult.Type.MISS && this.tools != null) {
            LocalPlayer player = PreviewRenderer.mc.player;
            Level level = player.level();
            Vec3 cam = PreviewRenderer.mc.gameRenderer.getMainCamera().getPosition();
            for (LittleTool t : this.tools) {
                t.render(level, (Player)player, event.getPoseStack(), cam, true);
            }
        }
    }

    @SubscribeEvent
    public void drawHighlight(RenderHighlightEvent.Block event) {
        LocalPlayer player = PreviewRenderer.mc.player;
        Level level = player.level();
        if (!LittleAction.canPlace((Player)player)) {
            return;
        }
        Vec3 cam = PreviewRenderer.mc.gameRenderer.getMainCamera().getPosition();
        PoseStack pose = event.getPoseStack();
        if (this.tools != null) {
            for (LittleTool t : this.tools) {
                t.render(level, (Player)player, pose, cam, true);
            }
        }
        if (!event.isCanceled() && level.getBlockState(event.getTarget().getBlockPos()).getBlock() instanceof BlockTile && level.getWorldBorder().isWithinBounds(event.getTarget().getBlockPos())) {
            VoxelShape shape;
            BlockPos pos = event.getTarget().getBlockPos();
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof BlockTile) {
                BlockTile block2 = (BlockTile)block;
                shape = block2.getSelectionShape((BlockGetter)level, pos);
            } else {
                shape = state.getShape((BlockGetter)level, pos, CollisionContext.of((Entity)player));
            }
            PreviewRenderer.renderShape(pose, event.getMultiBufferSource().getBuffer(RenderType.lines()), shape, (double)pos.getX() - cam.x, (double)pos.getY() - cam.y, (double)pos.getZ() - cam.z, 0.0f, 0.0f, 0.0f, 0.4f);
            event.setCanceled(true);
        }
        RenderSystem.enableCull();
    }

    public BlockHitResult blockHit() {
        LittleHitResult result;
        HitResult hitResult = PreviewRenderer.mc.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult b = (BlockHitResult)hitResult;
            return b;
        }
        hitResult = PreviewRenderer.mc.hitResult;
        if (hitResult instanceof LittleHitResult && (result = (LittleHitResult)hitResult).isBlock()) {
            return result.asBlockHit();
        }
        return null;
    }

    @SubscribeEvent
    public void onMouseWheelClick(InputEvent.InteractionKeyMappingTriggered event) {
        if (!event.isPickBlock() || this.tools == null) {
            return;
        }
        BlockHitResult hit = this.blockHit();
        for (LittleTool t : this.tools) {
            if (!t.onMouseWheelClickBlock((Level)PreviewRenderer.mc.level, (Player)PreviewRenderer.mc.player, hit)) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        if (!event.getLevel().isClientSide || this.tools == null) {
            return;
        }
        BlockHitResult hit = this.blockHit();
        for (LittleTool t : this.tools) {
            t.onLeftClick(event.getLevel(), event.getEntity(), hit);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getLevel().isClientSide || this.tools == null || event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
            return;
        }
        BlockHitResult hit = this.blockHit();
        for (LittleTool t : this.tools) {
            if (!t.onLeftClick(event.getLevel(), event.getEntity(), hit)) continue;
            event.setUseItem(TriState.TRUE);
        }
    }

    @SubscribeEvent
    public void onRightClickAir(PlayerInteractEvent.RightClickEmpty event) {
        if (!event.getLevel().isClientSide || this.tools == null) {
            return;
        }
        BlockHitResult hit = this.blockHit();
        for (LittleTool t : this.tools) {
            t.onRightClick(event.getLevel(), event.getEntity(), hit);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND || !event.getLevel().isClientSide || this.tools == null) {
            return;
        }
        BlockHitResult hit = this.blockHit();
        for (LittleTool t : this.tools) {
            if (!t.onRightClick((Level)PreviewRenderer.mc.level, (Player)PreviewRenderer.mc.player, hit)) continue;
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
        }
    }
}

