/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.tool;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.packet.item.WrenchRequestInfoPacket;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class LittleToolWrench
extends LittleTool {
    private List<StructureTooltip> requestingStructures;
    private List<StructureTooltip> receivedStructures;
    private long tickTime;
    private boolean received = true;

    public LittleToolWrench(ItemStack stack) {
        super(stack);
    }

    private boolean containsStructure(LittleStructure structure) {
        for (StructureTooltip s : this.requestingStructures) {
            if (s.structure != structure) continue;
            return true;
        }
        return false;
    }

    protected void scanLevel(LevelAccessor level, BlockPos.MutableBlockPos pos, BlockPos origin, int range) {
        for (int x = origin.getX() - range; x <= origin.getX() + range; ++x) {
            for (int y = origin.getY() - range; y <= origin.getY() + range; ++y) {
                for (int z = origin.getZ() - range; z <= origin.getZ() + range; ++z) {
                    pos.set(x, y, z);
                    BETiles be = BlockTile.loadBE((BlockGetter)level, (BlockPos)pos);
                    if (be == null) continue;
                    for (LittleStructure s : be.loadedStructures()) {
                        if (!s.hasWrenchInfo() || this.containsStructure(s)) continue;
                        try {
                            Vec3 center = s.getSurroundingBox().getAABB().getCenter();
                            this.requestingStructures.add(new StructureTooltip(s, center));
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
                    }
                }
            }
        }
    }

    public void receive(List<List<Component>> result) {
        this.received = true;
        if (result.size() == this.requestingStructures.size()) {
            for (int i = 0; i < this.requestingStructures.size(); ++i) {
                this.requestingStructures.get(i).receive(result.get(i));
            }
            this.receivedStructures = this.requestingStructures;
            this.requestingStructures = null;
        } else {
            this.requestingStructures = null;
        }
    }

    @Override
    public void tick(Level level, Player player, BlockHitResult blockHit) {
        if (this.tickTime <= System.currentTimeMillis() && this.received) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            BlockPos origin = player.blockPosition();
            pos.set((Vec3i)origin);
            this.requestingStructures = new ArrayList<StructureTooltip>();
            int range = LittleTiles.CONFIG.rendering.wrenchInfoRange;
            this.scanLevel((LevelAccessor)level, pos, origin, range);
            AABB bb = new AABB((double)(origin.getX() - range), (double)(origin.getY() - range), (double)(origin.getZ() - range), (double)(origin.getX() + 1 + range), (double)(origin.getY() + 1 + range), (double)(origin.getZ() + 1 + range));
            for (LittleEntity entity : LittleTilesClient.ANIMATION_HANDLER.find(bb)) {
                this.scanLevel((LevelAccessor)entity.getSubLevel(), pos, origin, range);
            }
            this.received = false;
            ArrayList<StructureLocation> structures = new ArrayList<StructureLocation>();
            for (int i = 0; i < this.requestingStructures.size(); ++i) {
                structures.add(this.requestingStructures.get((int)i).structure.getStructureLocation());
            }
            LittleTiles.NETWORK.sendToServer((CreativePacket)new WrenchRequestInfoPacket(structures));
            this.tickTime = System.currentTimeMillis() + (long)(LittleTiles.CONFIG.rendering.wrenchInfoRefresh * 1000.0);
        }
    }

    @Override
    public void render(Level level, Player player, PoseStack pose, Vec3 cam, boolean lines) {
        if (lines || this.receivedStructures == null || this.receivedStructures.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Quaternionf cameraOrientation = mc.getEntityRenderDispatcher().cameraOrientation();
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        buffer.endBatch();
        pose.pushPose();
        pose.translate((float)(-cam.x), (float)(-cam.y), (float)(-cam.z));
        for (StructureTooltip s : this.receivedStructures) {
            s.render(pose, (MultiBufferSource)buffer, mc.font, cameraOrientation);
        }
        pose.popPose();
        RenderSystem.disableDepthTest();
        buffer.endBatch();
        RenderSystem.enableDepthTest();
    }

    @Override
    public boolean onRightClick(Level level, Player player, BlockHitResult result) {
        return false;
    }

    @Override
    public boolean keyPressed(Level level, Player player, KeyMapping key) {
        return false;
    }

    @Override
    public void removed() {
    }

    public static class StructureTooltip {
        public final LittleStructure structure;
        public final Vec3 pos;
        public List<Component> info;

        public StructureTooltip(LittleStructure structure, Vec3 pos) {
            this.structure = structure;
            this.pos = pos;
        }

        public void receive(List<Component> info) {
            this.info = info;
        }

        public void render(PoseStack pose, MultiBufferSource buffer, Font font, Quaternionf cameraOrientation) {
            if (this.info == null) {
                return;
            }
            int light = 255;
            pose.pushPose();
            Vec3 pos = this.pos;
            Level level = this.structure.getStructureLevel();
            if (level instanceof IOrientatedLevel) {
                IOrientatedLevel l = (IOrientatedLevel)level;
                pos = l.getOrigin().transformPointToWorld(pos);
            }
            pose.translate(pos.x, pos.y, pos.z);
            pose.mulPose(cameraOrientation);
            float scale = 0.005f;
            pose.scale(scale, -scale, scale);
            Matrix4f matrix4f = pose.last().pose();
            int j = 255;
            int x = 0;
            for (int i = 0; i < this.info.size(); ++i) {
                Component text = this.info.get(i);
                float f1 = -font.width((FormattedText)text) / 2;
                font.drawInBatch(text, f1, (float)x, -1, true, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, j, light);
                x += 10;
            }
            pose.popPose();
        }
    }
}

