/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.action;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionBoxes;
import team.creative.littletiles.common.action.LittleActions;
import team.creative.littletiles.common.action.exception.LittleActionException;
import team.creative.littletiles.common.action.exception.NotAllowedToPlaceColorException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.config.LittlePermissionBuild;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesSimple;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class LittleActionColorBoxes
extends LittleActionBoxes {
    public int color;
    public boolean toVanilla;
    public transient boolean doneSomething;
    private transient double colorVolume;
    public transient Int2ObjectMap<LittleBoxes> revertList;

    public LittleActionColorBoxes(Level level, LittleBoxes boxes, int color, boolean toVanilla) {
        super(level, boxes);
        this.color = color;
        this.toVanilla = toVanilla;
    }

    public LittleActionColorBoxes(UUID levelUUID, LittleBoxes boxes, int color, boolean toVanilla) {
        super(levelUUID, boxes);
        this.color = color;
        this.toVanilla = toVanilla;
    }

    public LittleActionColorBoxes() {
    }

    public void addRevert(int color, BlockPos pos, LittleGrid grid, Iterable<LittleBox> boxes) {
        LittleBoxes reverted = (LittleBoxes)this.revertList.get(color);
        if (reverted == null) {
            reverted = new LittleBoxesSimple(pos, grid);
            this.revertList.put(color, (Object)reverted);
        }
        reverted.addBoxes(grid, pos, boxes);
    }

    public boolean shouldSkipTile(IParentCollection parent, LittleTile tile) {
        return false;
    }

    public ColorIngredient action(BETiles be, List<LittleBox> boxes, ColorIngredient gained, boolean simulate, LittleGrid grid) {
        this.doneSomething = false;
        this.colorVolume = 0.0;
        Consumer<BETiles.BlockEntityInteractor> consumer = x -> {
            block2: for (IParentCollection parent : be.groups()) {
                LittleCollection toRemove = new LittleCollection();
                LittleCollection toAdd = new LittleCollection();
                for (LittleTile element : parent) {
                    if (this.shouldSkipTile(parent, element)) continue;
                    for (LittleBox box : element) {
                        LittleBox intersecting;
                        block12: {
                            intersecting = null;
                            boolean intersects = false;
                            for (int j = 0; j < boxes.size(); ++j) {
                                if (!LittleBox.intersectsWith(box, (LittleBox)boxes.get(j))) continue;
                                intersects = true;
                                intersecting = (LittleBox)boxes.get(j);
                                break;
                            }
                            if (!intersects) continue;
                            try {
                                if (parent.isStructure() && parent.getStructure().hasStructureColor()) {
                                    LittleStructure structure = parent.getStructure();
                                    if (structure.getStructureColor() == this.color) continue block2;
                                    double volume = structure.getPercentVolume();
                                    this.colorVolume += volume;
                                    gained.add(ColorIngredient.getColors(this.color, structure.getDefaultColor(), volume));
                                    if (simulate) continue block2;
                                    this.addRevert(structure.getStructureColor(), be.getBlockPos(), grid, Arrays.asList(intersecting));
                                    structure.paint(this.color);
                                }
                                break block12;
                            }
                            catch (CorruptedConnectionException | NotYetConnectedException e) {}
                            continue block2;
                        }
                        if (element.color == this.color) continue;
                        this.doneSomething = true;
                        if (!box.equals(intersecting)) {
                            if (simulate) {
                                double volume = 0.0;
                                ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                                LittleBoxReturnedVolume returnedVolume = new LittleBoxReturnedVolume();
                                box.cutOut(grid, boxes, cutout, returnedVolume);
                                for (LittleBox box2 : cutout) {
                                    this.colorVolume += box2.getPercentVolume(grid);
                                    volume += box2.getPercentVolume(grid);
                                }
                                if (returnedVolume.has()) {
                                    this.colorVolume += returnedVolume.getPercentVolume(grid);
                                    volume += returnedVolume.getPercentVolume(grid);
                                }
                                gained.add(ColorIngredient.getColors(element, volume));
                                continue;
                            }
                            ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
                            List<LittleBox> newBoxes = box.cutOut(grid, boxes, cutout, null);
                            if (newBoxes == null) continue;
                            this.addRevert(element.color, be.getBlockPos(), grid, cutout);
                            LittleTile coloredElement = element.copy();
                            coloredElement.color = this.color;
                            toAdd.add((LittleElement)coloredElement, cutout);
                            toAdd.add((LittleElement)element, newBoxes);
                            toRemove.add((LittleElement)element, box);
                            continue;
                        }
                        if (simulate) {
                            double volume = box.getPercentVolume(grid);
                            this.colorVolume += volume;
                            gained.add(ColorIngredient.getColors(element, volume));
                            continue;
                        }
                        this.addRevert(element.color, be.getBlockPos(), grid, Arrays.asList(box));
                        LittleTile coloredElement = element.copy();
                        coloredElement.color = this.color;
                        toAdd.add((LittleElement)coloredElement, box);
                        toRemove.add((LittleElement)element, box);
                    }
                }
                x.get(parent).removeAll(toRemove);
                x.get(parent).addAll(toAdd);
            }
        };
        if (simulate) {
            be.updateTilesSecretly(consumer);
        } else {
            be.updateTiles(consumer);
        }
        ColorIngredient toDrain = ColorIngredient.getColors(this.color);
        toDrain.scale(this.colorVolume);
        return gained.sub(toDrain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action(Level level, Player player, BlockPos pos, BlockState state, List<LittleBox> boxes, LittleGrid grid) throws LittleActionException {
        LittlePermissionBuild config = (LittlePermissionBuild)LittleTiles.CONFIG.build.get(player);
        if (ColorUtils.alpha((int)this.color) < LittleTiles.CONFIG.getMinimumTransparency(player)) {
            throw new NotAllowedToPlaceColorException(config);
        }
        LittleActionColorBoxes.fireBlockBreakEvent(level, pos, player);
        BETiles blockEntity = LittleActionColorBoxes.loadBE(player, level, pos, null, true, 0);
        if (blockEntity instanceof BETiles) {
            BETiles be = blockEntity;
            if (grid != be.getGrid()) {
                if (grid.count < be.getGrid().count) {
                    for (LittleBox box : boxes) {
                        box.convertTo(grid, be.getGrid());
                    }
                    grid = be.getGrid();
                } else {
                    be.convertTo(grid);
                }
            }
            ColorIngredient gained = new ColorIngredient();
            ColorIngredient toDrain = this.action(be, boxes, gained, true, grid);
            LittleIngredients gainedIngredients = new LittleIngredients(gained);
            LittleIngredients drainedIngredients = new LittleIngredients(toDrain);
            LittleInventory inventory = new LittleInventory(player);
            try {
                inventory.startSimulation();
                LittleActionColorBoxes.give(player, inventory, gainedIngredients);
                LittleActionColorBoxes.take(player, inventory, drainedIngredients);
            }
            finally {
                inventory.stopSimulation();
            }
            LittleActionColorBoxes.give(player, inventory, gainedIngredients);
            LittleActionColorBoxes.take(player, inventory, drainedIngredients);
            this.action(be, boxes, gained, false, grid);
            be.combineAllTiles(true);
            if (this.toVanilla || !this.doneSomething) {
                be.convertBlockToVanilla();
            }
        }
    }

    @Override
    public Boolean action(Player player) throws LittleActionException {
        this.revertList = new Int2ObjectOpenHashMap();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(Player player) {
        ArrayList<LittleActionColorBoxes> actions = new ArrayList<LittleActionColorBoxes>();
        for (Int2ObjectMap.Entry entry : this.revertList.int2ObjectEntrySet()) {
            LittleBoxes boxes = ((LittleBoxes)entry.getValue()).copy();
            boxes.convertToSmallest();
            actions.add(new LittleActionColorBoxes(this.levelUUID, boxes, entry.getIntKey(), true));
        }
        if (actions.size() == 1) {
            return (LittleAction)((Object)actions.getFirst());
        }
        return new LittleActions(actions.toArray(new LittleAction[0]));
    }

    @Override
    public LittleAction mirror(Axis axis, LittleBoxAbsolute box) {
        LittleActionColorBoxes action = new LittleActionColorBoxes();
        action.color = this.color;
        action.toVanilla = this.toVanilla;
        return this.assignMirror(action, axis, box);
    }

    public static class LittleActionColorBoxesFiltered
    extends LittleActionColorBoxes {
        public BiFilter<IParentCollection, LittleTile> filter;

        public LittleActionColorBoxesFiltered(Level level, LittleBoxes boxes, int color, boolean toVanilla, BiFilter<IParentCollection, LittleTile> filter) {
            super(level, boxes, color, toVanilla);
            this.filter = filter;
        }

        public LittleActionColorBoxesFiltered() {
        }

        @Override
        public boolean shouldSkipTile(IParentCollection parent, LittleTile tile) {
            return !this.filter.is((Object)parent, (Object)tile);
        }

        @Override
        public LittleAction mirror(Axis axis, LittleBoxAbsolute box) {
            LittleActionColorBoxesFiltered action = new LittleActionColorBoxesFiltered();
            action.filter = this.filter;
            action.color = this.color;
            action.toVanilla = this.toVanilla;
            return this.assignMirror(action, axis, box);
        }
    }
}

