/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.mc;

import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.client.IFakeRenderingBlock;
import team.creative.littletiles.api.common.block.ILittleMCBlock;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.config.LittlePermissionInteract;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class BlockFlowingWater
extends Block
implements ILittleMCBlock,
IFakeRenderingBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public final Holder<Block> still;

    public BlockFlowingWater(Holder<Block> still) {
        super(BlockBehaviour.Properties.of().liquid().strength(1.5f, 6.0f));
        this.still = still;
    }

    @Override
    public Block asVanillaBlock() {
        return this;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace());
    }

    @Override
    public boolean noCollision() {
        return true;
    }

    @Override
    public boolean isFluid(TagKey<Fluid> fluid) {
        return fluid.equals((Object)FluidTags.WATER);
    }

    @Override
    public boolean checkEntityCollision() {
        return true;
    }

    @Override
    public boolean canBeConvertedToVanilla() {
        return false;
    }

    @Override
    public BlockState getFakeState(BlockState state) {
        return Blocks.WATER.defaultBlockState();
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result) {
        if (player.getMainHandItem().getItem() instanceof BucketItem && ((LittlePermissionInteract)LittleTiles.CONFIG.interact.get((Player)player)).allowFlowingWater) {
            Direction facing = (Direction)tile.getState().getValue((Property)BlockStateProperties.FACING);
            int index = facing.ordinal() + 1;
            BlockState newState = index >= Direction.values().length ? ((Block)LittleTilesRegistry.WATER.value()).defaultBlockState() : (BlockState)tile.getState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.values()[index]);
            parent.getBE().updateTiles(x -> {
                LittleTile newFlowing = new LittleTile(newState, -1, box.copy());
                x.noneStructureTiles().remove(tile, box);
                x.noneStructureTiles().add(newFlowing);
            });
            return InteractionResult.SUCCESS;
        }
        return ILittleMCBlock.super.use(parent, tile, box, player, result);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canBeRenderCombined(LittleTile thisTile, LittleTile tile) {
        if (tile.getBlock() == this) {
            return true;
        }
        return tile.getBlock() == LittleTilesRegistry.WATER.value();
    }

    @Override
    public Vector3d getFogColor(IParentCollection parent, LittleTile tile, Entity entity, Vector3d originalColor, float partialTicks) {
        float f12 = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AttributeInstance attributeinstance = living.getAttribute(Attributes.OXYGEN_BONUS);
            f12 = (float)(attributeinstance != null ? attributeinstance.getValue() : 0.0) * 0.2f;
            if (living.hasEffect(MobEffects.WATER_BREATHING)) {
                f12 = f12 * 0.3f + 0.6f;
            }
        }
        return new Vector3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
    }

    @Override
    public BlockState transform(BlockState state, IntMatrix3c matrix, LittleVec doubledCenter) {
        return (BlockState)state.setValue(FACING, (Comparable)Facing.get((Direction)((Direction)state.getValue(FACING))).transform(matrix).toVanilla());
    }
}

