/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxUtils;
import team.creative.creativecore.common.util.math.collision.CollidingPlane;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.collision.PlaneCache;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.entity.INoPushEntity;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.entity.OrientationAwareEntity;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.structure.animation.PhysicalState;

public abstract class LittleEntityPhysic<T extends LittleEntity<? extends LittleEntityPhysic>> {
    private static final Predicate<Entity> NO_ANIMATION = x -> !(x instanceof INoPushEntity);
    private static final TagKey<EntityType<?>> NO_COLLISION = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"littletiles", (String)"no_collision"));
    protected double minX;
    protected double minY;
    protected double minZ;
    protected double maxX;
    protected double maxY;
    protected double maxZ;
    protected boolean preventPush = false;
    protected boolean noCollision;
    private ABB bb;
    private Vec3 center;
    private boolean bbChanged = false;
    public final T parent;

    public LittleEntityPhysic(T parent) {
        this.parent = parent;
        this.bb = new ABB(parent.getBoundingBox());
    }

    public double get(Facing facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Facing.EAST -> this.maxX;
            case Facing.WEST -> this.minX;
            case Facing.UP -> this.maxY;
            case Facing.DOWN -> this.minY;
            case Facing.SOUTH -> this.maxZ;
            case Facing.NORTH -> this.minZ;
        };
    }

    public void set(Facing facing, double value) {
        switch (facing) {
            case EAST: {
                this.maxX = value;
                break;
            }
            case WEST: {
                this.minX = value;
                break;
            }
            case UP: {
                this.maxY = value;
                break;
            }
            case DOWN: {
                this.minY = value;
                break;
            }
            case SOUTH: {
                this.maxZ = value;
                break;
            }
            case NORTH: {
                this.minZ = value;
            }
        }
    }

    public IVecOrigin getOrigin() {
        return ((LittleEntity)this.parent).getOrigin();
    }

    public void ignoreCollision(Runnable run) {
        this.preventPush = true;
        try {
            run.run();
        }
        finally {
            this.preventPush = false;
        }
    }

    public boolean shouldPush() {
        return !this.preventPush;
    }

    public abstract void setSubLevel(LittleSubLevel var1);

    public abstract void tick();

    public void setBB(ABB bb) {
        if (bb.maxX >= Double.MAX_VALUE) {
            return;
        }
        this.bb = bb;
        this.bbChanged = true;
    }

    public void updateBoundingBox() {
        boolean originChanged;
        if (this.bb == null || ((LittleEntity)this.parent).getSubLevel() == null) {
            return;
        }
        boolean bl = originChanged = ((LittleEntity)this.parent).getOrigin().hasChanged() || ((LittleEntity)this.parent).getOrigin().hasChanged();
        if (this.bbChanged || originChanged) {
            if (originChanged) {
                ((LittleEntity)this.parent).markOriginChange();
            }
            this.parent.setBoundingBox(((LittleEntity)this.parent).getOrigin().getAABB(this.bb).toVanilla());
            if (originChanged) {
                ((LittleEntity)this.parent).resetOriginChange();
            }
            this.center = this.parent.getBoundingBox().getCenter();
            this.bbChanged = false;
        }
    }

    public ABB getOBB() {
        return this.bb;
    }

    public Vec3 getCenter() {
        return this.center;
    }

    public void load(CompoundTag nbt) {
        this.preventPush = true;
        this.set(nbt.getDouble("offX"), nbt.getDouble("offY"), nbt.getDouble("offZ"), nbt.getDouble("rotX"), nbt.getDouble("rotY"), nbt.getDouble("rotZ"));
        this.preventPush = false;
        this.minX = nbt.getDouble("x");
        this.minY = nbt.getDouble("y");
        this.minZ = nbt.getDouble("z");
        this.maxX = nbt.getDouble("x2");
        this.maxY = nbt.getDouble("y2");
        this.maxZ = nbt.getDouble("z2");
        this.setBB(new ABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ));
        this.loadExtra(nbt);
    }

    public abstract void loadExtra(CompoundTag var1);

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        IVecOrigin origin = this.getOrigin();
        nbt.putDouble("offX", origin.offX());
        nbt.putDouble("offY", origin.offY());
        nbt.putDouble("offZ", origin.offZ());
        nbt.putDouble("rotX", origin.rotX());
        nbt.putDouble("rotY", origin.rotY());
        nbt.putDouble("rotZ", origin.rotZ());
        nbt.putDouble("x", this.minX);
        nbt.putDouble("y", this.minY);
        nbt.putDouble("z", this.minZ);
        nbt.putDouble("x2", this.maxX);
        nbt.putDouble("y2", this.maxY);
        nbt.putDouble("z2", this.maxZ);
        this.saveExtra(nbt);
        return nbt;
    }

    protected abstract void saveExtra(CompoundTag var1);

    public void set(PhysicalState state) {
        this.set(state.offX(), state.offY(), state.offZ(), state.rotX(), state.rotY(), state.rotZ());
    }

    public void set(double offX, double offY, double offZ, double rotX, double rotY, double rotZ) {
        IVecOrigin origin = this.getOrigin();
        this.moveAndRotateAnimation(offX - origin.offX(), offY - origin.offY(), offZ - origin.offZ(), rotX - origin.rotX(), rotY - origin.rotY(), rotZ - origin.rotZ());
    }

    public void moveAndRotateAnimation(double x, double y, double z, double rotX, double rotY, double rotZ) {
        if (x == 0.0 && y == 0.0 && z == 0.0 && rotX == 0.0 && rotY == 0.0 && rotZ == 0.0) {
            return;
        }
        CollisionCoordinator coordinator = new CollisionCoordinator(x, y, z, rotX, rotY, rotZ, this.getOrigin());
        if (LittleTiles.CONFIG.general.enableAnimationCollision) {
            this.transform(coordinator);
        }
        coordinator.finish();
    }

    public void transform(CollisionCoordinator coordinator) {
        if (this.preventPush || ((LittleEntity)this.parent).noClip()) {
            return;
        }
        this.noCollision = true;
        List entities = ((LittleEntity)this.parent).getRealLevel().getEntities(this.parent, coordinator.computeSurroundingBox(this.bb).toVanilla(), NO_ANIMATION);
        if (!entities.isEmpty()) {
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = (Entity)entities.get(i);
                if (entity.getType().is(NO_COLLISION)) continue;
                AABB entityBB = entity.getBoundingBox();
                AABB originalBox = entity.getBoundingBox();
                Vec3d center = new Vec3d(entityBB.getCenter());
                double radius = center.distanceSqr(entityBB.minX, entityBB.minY, entityBB.minZ);
                Double t = null;
                Facing facing = null;
                ArrayList<PlaneCache> cached = new ArrayList<PlaneCache>();
                ABB inverseBB = coordinator.original().getOBB(originalBox);
                Iterable shapes = ((LittleEntity)this.parent).getSubLevel().getCollisions(entity, coordinator.computeInverseSurroundingBoxInternal(inverseBB).toVanilla());
                for (VoxelShape shape : shapes) {
                    block2: for (AABB bb : shape.toAabbs()) {
                        PlaneCache cache = new PlaneCache(bb, coordinator);
                        cached.add(cache);
                        if (t != null && t == 0.0) continue;
                        for (CollidingPlane plane : cache.planes) {
                            Double tempT = plane.binarySearch(t, entityBB, radius, center, coordinator);
                            if (tempT == null) continue;
                            t = tempT;
                            facing = plane.facing;
                            if (t == 0.0) continue block2;
                        }
                    }
                    if (t == null) continue;
                    Vec3d newCenter = new Vec3d(center);
                    coordinator.transform(newCenter, Double.valueOf(1.0 - t));
                    entityBB = entityBB.move(newCenter.x - center.x, newCenter.y - center.y, newCenter.z - center.z);
                }
                Axis one = null;
                Axis two = null;
                boolean ignoreOne = false;
                Boolean positiveOne = null;
                boolean ignoreTwo = false;
                Boolean positiveTwo = null;
                double maxVolume = 0.0;
                ArrayList<PlaneCache> intersecting = new ArrayList<PlaneCache>();
                ArrayList<Facing> intersectingFacing = new ArrayList<Facing>();
                ABB entityOBB = coordinator.moved().getOBB(entityBB);
                center.set(entityOBB.getCenter());
                for (PlaneCache cache : cached) {
                    Facing collideFacing;
                    if (!entityOBB.intersects(cache.bb) || (collideFacing = CollidingPlane.getDirection((CollisionCoordinator)coordinator, (PlaneCache)cache, (Vec3d)center)) == null || !coordinator.hasRotation && (!coordinator.hasTranslation || coordinator.translation.get(collideFacing.axis) > 0.0 != collideFacing.positive)) continue;
                    double intersectingVolume = BoxUtils.getIntersectionVolume((AABB)cache.bb, (ABB)entityOBB);
                    if (maxVolume == 0.0 || intersectingVolume > maxVolume) {
                        maxVolume = intersectingVolume;
                        facing = collideFacing;
                    }
                    intersecting.add(cache);
                    intersectingFacing.add(collideFacing);
                }
                Vec3d pushVec = new Vec3d();
                double scale = 0.0;
                if (!intersecting.isEmpty()) {
                    one = facing.one();
                    two = facing.two();
                    positiveOne = null;
                    positiveTwo = null;
                    for (Facing collideFacing : intersectingFacing) {
                        if (!ignoreOne && collideFacing.axis == one) {
                            if (positiveOne == null) {
                                positiveOne = collideFacing.positive;
                            } else if (collideFacing.positive != positiveOne) {
                                ignoreOne = true;
                            }
                        } else if (!ignoreTwo && collideFacing.axis == two) {
                            if (positiveTwo == null) {
                                positiveTwo = collideFacing.positive;
                            } else if (collideFacing.positive != positiveTwo) {
                                ignoreTwo = true;
                            }
                        }
                        if (!ignoreOne || !ignoreTwo) continue;
                        break;
                    }
                    pushVec.set(facing.axis, (double)facing.offset());
                    if (!ignoreOne && positiveOne != null) {
                        pushVec.set(one, positiveOne != false ? 1.0 : -1.0);
                    }
                    if (!ignoreTwo && positiveTwo != null) {
                        pushVec.set(two, positiveTwo != false ? 1.0 : -1.0);
                    }
                    for (int j = 0; j < intersecting.size(); ++j) {
                        Facing collideFacing;
                        collideFacing = (Facing)intersectingFacing.get(j);
                        if (ignoreOne && collideFacing.axis == one || ignoreTwo && collideFacing.axis == two) continue;
                        scale = ((PlaneCache)intersecting.get(j)).getPushOutScale(scale, entityOBB, pushVec);
                    }
                }
                boolean collidedHorizontally = entity.horizontalCollision;
                boolean collidedVertically = entity.verticalCollision;
                boolean onGround = entity.onGround();
                Vec3d rotatedVec = new Vec3d(pushVec);
                coordinator.moved().rotation().transform(rotatedVec);
                double moveX = entityBB.minX - originalBox.minX + rotatedVec.x * scale;
                double moveY = entityBB.minY - originalBox.minY + rotatedVec.y * scale;
                double moveZ = entityBB.minZ - originalBox.minZ + rotatedVec.z * scale;
                entity.move(MoverType.SELF, new Vec3(moveX, moveY, moveZ));
                if (LittleTiles.CONFIG.general.enableCollisionMotion) {
                    entity.setDeltaMovement(entity.getDeltaMovement().add(moveX, moveY, moveZ));
                }
                if (moveX != 0.0 || moveZ != 0.0) {
                    collidedHorizontally = true;
                }
                if (moveY != 0.0) {
                    collidedVertically = true;
                    onGround = true;
                }
                entity.horizontalCollision = collidedHorizontally;
                entity.verticalCollision = collidedVertically;
                entity.setOnGround(onGround);
            }
        }
        for (OrientationAwareEntity child : ((LittleEntity)this.parent).children()) {
            child.transform(coordinator);
        }
        this.noCollision = false;
    }
}

