/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.filter;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.util.CompoundSerializer;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.registry.LittleMissingBlock;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;

public class TileFilters {
    public static BiFilter<IParentCollection, LittleTile> block(Block block) {
        return new TileBlockFilter(block);
    }

    public static BiFilter<IParentCollection, LittleTile> tag(TagKey<Block> tag) {
        return new TileTagFilter(tag);
    }

    public static BiFilter<IParentCollection, LittleTile> color(int color) {
        return new TileColorFilter(color);
    }

    public static BiFilter<IParentCollection, LittleTile> noStructure() {
        return new TileNoStructureFilter();
    }

    public static BiFilter<IParentCollection, LittleTile> and(BiFilter<IParentCollection, LittleTile> ... filters) {
        return BiFilter.and(filters);
    }

    public static BiFilter<IParentCollection, LittleTile> or(BiFilter<IParentCollection, LittleTile> ... filters) {
        return BiFilter.or(filters);
    }

    public static BiFilter<IParentCollection, LittleTile> not(BiFilter<IParentCollection, LittleTile> filter) {
        return BiFilter.not(filter);
    }

    public static BiFilter<IParentCollection, LittleTile> name(String name) {
        return new TileNameFilter(name);
    }

    public static BiFilter<IParentCollection, LittleTile> missing() {
        return new TileMissingFilter();
    }

    public static BiFilter<IParentCollection, LittleTile> of(LittleElement element) {
        return TileFilters.and(TileFilters.block(element.getState().getBlock()), TileFilters.color(element.color));
    }

    static {
        BiFilter.SERIALIZER.register("b", TileBlockFilter.class).register("c", TileColorFilter.class).register("no", TileNoStructureFilter.class).register("t", TileTagFilter.class).register("n", TileNameFilter.class).register("m", TileMissingFilter.class);
    }

    public static class TileBlockFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public final Block block;

        public TileBlockFilter(Block block) {
            this.block = block;
        }

        public TileBlockFilter(CompoundTag nbt) {
            this.block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)nbt.getString("block")));
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.putString("block", this.block.builtInRegistryHolder().key().location().toString());
            return tag;
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return tile.getBlock().is(this.block);
        }
    }

    public static class TileTagFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public final TagKey<Block> tag;

        public TileTagFilter(TagKey<Block> tag) {
            this.tag = tag;
        }

        public TileTagFilter(CompoundTag nbt) {
            this.tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("tag")));
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.putString("tag", this.tag.location().toString());
            return tag;
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return tile.getBlock().is(this.tag);
        }
    }

    public static class TileColorFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public final int color;

        public TileColorFilter(int color) {
            this.color = color;
        }

        public TileColorFilter(CompoundTag nbt) {
            this.color = nbt.getInt("color");
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("color", this.color);
            return tag;
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return tile.color == this.color;
        }
    }

    public static class TileNoStructureFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public TileNoStructureFilter() {
        }

        public TileNoStructureFilter(CompoundTag tag) {
        }

        public CompoundTag write() {
            return new CompoundTag();
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return !parent.isStructure();
        }
    }

    public static class TileNameFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public final String name;

        public TileNameFilter(String name) {
            this.name = name;
        }

        public TileNameFilter(CompoundTag nbt) {
            this.name = nbt.getString("name");
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.putString("name", this.name);
            return tag;
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return tile.getBlock().blockName().contains(this.name);
        }
    }

    public static class TileMissingFilter
    implements BiFilter<IParentCollection, LittleTile>,
    CompoundSerializer {
        public TileMissingFilter() {
        }

        public TileMissingFilter(CompoundTag nbt) {
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            return tag;
        }

        public boolean is(IParentCollection parent, LittleTile tile) {
            return tile.getBlock() instanceof LittleMissingBlock;
        }
    }
}

