/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control.animation;

import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.tree.GuiTree;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.common.gui.control.animation.GuiAnimationViewer;
import team.creative.littletiles.common.gui.control.animation.GuiAnimationViewerStorage;
import team.creative.littletiles.common.gui.tool.blueprint.GuiBlueprintAnimationHandler;

public class GuiAnimationPanel
extends GuiParent {
    public final GuiTree tree;
    public final GuiAnimationViewerStorage storage;
    public final boolean options;
    public final GuiBlueprintAnimationHandler animation;

    public GuiAnimationPanel(GuiTree tree, GuiAnimationViewerStorage storage, boolean options, GuiBlueprintAnimationHandler animation) {
        super("animation", (GuiFlow)GuiFlow.STACK_Y);
        this.setExpandable();
        this.tree = tree;
        this.storage = storage;
        this.options = options;
        this.animation = animation;
        GuiAnimationViewer viewer = new GuiAnimationViewer("viewer", storage);
        this.add(viewer.setExpandable());
        GuiParent animationButtons = new GuiParent((GuiFlow)GuiFlow.STACK_X).setAlign(Align.CENTER);
        this.add(animationButtons.setExpandableX());
        animationButtons.add(new GuiButtonIcon("perspective", Icon.CAMERA, x -> viewer.nextProjection()).setTooltip(new TextBuilder().translate("gui.blueprint.perspective").build()));
        animationButtons.add(new GuiButtonIcon("home", Icon.HOUSE, x -> viewer.resetView()).setTooltip(new TextBuilder().translate("gui.blueprint.home").build()));
        if (animation != null) {
            animationButtons.add(new GuiButtonIcon("play", Icon.PLAY, x -> animation.play()).setTooltip(new TextBuilder().translate("gui.blueprint.play").build()));
            animationButtons.add(new GuiButtonIcon("pause", Icon.PAUSE, x -> animation.pause()).setTooltip(new TextBuilder().translate("gui.blueprint.pause").build()));
            animationButtons.add(new GuiButtonIcon("stop", Icon.STOP, x -> animation.stop()).setTooltip(new TextBuilder().translate("gui.blueprint.stop").build()));
        }
        GuiParent checkboxes = new GuiParent((GuiFlow)GuiFlow.FIT_X).setAlign(Align.CENTER);
        this.add(checkboxes.setExpandableX());
        if (options) {
            checkboxes.add((GuiControl)new GuiCheckBox("filter", tree.hasCheckboxes()).setTranslate("gui.blueprint.view.filter").consumeChanged(x -> {
                tree.setCheckboxes(x.booleanValue(), false);
                tree.updateTree();
            }));
            checkboxes.add((GuiControl)new GuiCheckBox("highlight", storage.highlightSelected()).setTranslate("gui.blueprint.view.highlight").consumeChanged(x -> storage.highlightSelected((boolean)x)));
        }
    }

    public void refresh() {
        if (this.options) {
            ((GuiCheckBox)this.get((String)"filter", GuiCheckBox.class)).value = this.tree.hasCheckboxes();
            ((GuiCheckBox)this.get((String)"highlight", GuiCheckBox.class)).value = this.storage.highlightSelected();
        }
    }
}

