/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control.filter;

import net.minecraft.world.entity.player.Player;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.filter.TileFilters;
import team.creative.littletiles.common.gui.control.filter.GuiElementFilterBlock;
import team.creative.littletiles.common.gui.control.filter.GuiElementFilterColor;
import team.creative.littletiles.common.gui.control.filter.GuiElementFilterGroup;
import team.creative.littletiles.common.gui.control.filter.GuiElementFilterMissing;
import team.creative.littletiles.common.gui.control.filter.GuiElementFilterName;
import team.creative.littletiles.common.gui.control.filter.GuiElementFilterTag;

public abstract class GuiElementFilter
extends GuiParent {
    public static GuiElementFilter ofGroup(Player player, BiFilter<IParentCollection, LittleTile> filter) {
        if (filter instanceof BiFilter.BiFilterNot || filter instanceof BiFilter.BiFilterAnd || filter instanceof BiFilter.BiFilterOr) {
            return GuiElementFilter.of(player, filter);
        }
        if (filter == null) {
            return new GuiElementFilterGroup(player, GuiElementFilterGroup.GuiElementFilterOperator.OR, new BiFilter[0]);
        }
        return new GuiElementFilterGroup(player, GuiElementFilterGroup.GuiElementFilterOperator.OR, filter);
    }

    public static GuiElementFilter of(Player player, BiFilter<IParentCollection, LittleTile> filter) {
        if (filter instanceof BiFilter.BiFilterNot) {
            BiFilter.BiFilterNot not = (BiFilter.BiFilterNot)filter;
            BiFilter biFilter = not.filter();
            if (biFilter instanceof BiFilter.BiFilterAnd) {
                BiFilter.BiFilterAnd and = (BiFilter.BiFilterAnd)biFilter;
                return new GuiElementFilterGroup(player, GuiElementFilterGroup.GuiElementFilterOperator.NOT_AND, and.filters());
            }
            biFilter = not.filter();
            if (biFilter instanceof BiFilter.BiFilterOr) {
                BiFilter.BiFilterOr or = (BiFilter.BiFilterOr)biFilter;
                return new GuiElementFilterGroup(player, GuiElementFilterGroup.GuiElementFilterOperator.NOT_OR, or.filters());
            }
            biFilter = not.filter();
            if (biFilter instanceof BiFilter.BiFilterNot) {
                BiFilter.BiFilterNot not2 = (BiFilter.BiFilterNot)biFilter;
                return GuiElementFilter.of(player, (BiFilter<IParentCollection, LittleTile>)not2.filter());
            }
            return new GuiElementFilterGroup(player, GuiElementFilterGroup.GuiElementFilterOperator.NOT_OR, not.filter());
        }
        if (filter instanceof BiFilter.BiFilterAnd) {
            BiFilter.BiFilterAnd and = (BiFilter.BiFilterAnd)filter;
            return new GuiElementFilterGroup(player, GuiElementFilterGroup.GuiElementFilterOperator.AND, and.filters());
        }
        if (filter instanceof BiFilter.BiFilterOr) {
            BiFilter.BiFilterOr or = (BiFilter.BiFilterOr)filter;
            return new GuiElementFilterGroup(player, GuiElementFilterGroup.GuiElementFilterOperator.OR, or.filters());
        }
        if (filter instanceof TileFilters.TileBlockFilter) {
            TileFilters.TileBlockFilter block = (TileFilters.TileBlockFilter)filter;
            return new GuiElementFilterBlock(player, block.block);
        }
        if (filter instanceof TileFilters.TileColorFilter) {
            TileFilters.TileColorFilter color = (TileFilters.TileColorFilter)filter;
            return new GuiElementFilterColor(color.color);
        }
        if (filter instanceof TileFilters.TileTagFilter) {
            TileFilters.TileTagFilter tag = (TileFilters.TileTagFilter)filter;
            return new GuiElementFilterTag(tag.tag);
        }
        if (filter instanceof TileFilters.TileTagFilter) {
            TileFilters.TileTagFilter tag = (TileFilters.TileTagFilter)filter;
            return new GuiElementFilterTag(tag.tag);
        }
        if (filter instanceof TileFilters.TileNameFilter) {
            TileFilters.TileNameFilter tag = (TileFilters.TileNameFilter)filter;
            return new GuiElementFilterName(tag.name);
        }
        if (filter instanceof TileFilters.TileMissingFilter) {
            return new GuiElementFilterMissing();
        }
        return new GuiElementFilterGroup(player, GuiElementFilterGroup.GuiElementFilterOperator.OR, new BiFilter[0]);
    }

    public GuiElementFilter() {
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
    }

    public abstract BiFilter<IParentCollection, LittleTile> get();
}

