/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal;

import java.util.ArrayList;
import java.util.List;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.IGuiSignalStructure;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;

public class GuiComponentSearch {
    public IGuiSignalStructure item;

    public GuiComponentSearch(IGuiSignalStructure item) {
        this.item = item;
    }

    public List<GuiSignalComponent> search(boolean input, boolean output, boolean includeRelations) {
        ArrayList<GuiSignalComponent> list = new ArrayList<GuiSignalComponent>();
        if (input) {
            this.gatherInputs(this.item, "", list, includeRelations, true);
        }
        if (output) {
            this.gatherOutputs(this.item, "", list, includeRelations, true);
        }
        return list;
    }

    public GuiSignalComponent[] internalOutputs() {
        LittleStructureType type = this.item.getStructureType();
        if (type != null && type.outputs != null) {
            GuiSignalComponent[] components = new GuiSignalComponent[type.outputs.size()];
            for (int i = 0; i < type.outputs.size(); ++i) {
                components[i] = new GuiSignalComponent("b" + i, this.item.getTitle(), type.outputs.get(i), false, false, i);
            }
            return components;
        }
        return null;
    }

    public List<GuiSignalComponent> externalOutputs() {
        ArrayList<GuiSignalComponent> components = new ArrayList<GuiSignalComponent>();
        this.addExternalOutputs(this.item, "", components, false);
        return components;
    }

    protected void addInput(IGuiSignalStructure item, String prefix, List<GuiSignalComponent> list, boolean includeRelations) {
        int i;
        LittleStructureType type = item.getStructureType();
        if (type != null && type.inputs != null) {
            for (i = 0; i < type.inputs.size(); ++i) {
                list.add(new GuiSignalComponent(prefix + "a" + i, item.getTitle(), type.inputs.get(i), true, false, i));
            }
        }
        i = 0;
        for (IGuiSignalStructure child : item.children()) {
            ISignalComponent com;
            if (child == this.item) {
                ++i;
                continue;
            }
            LittleStructure structure = child.getStructure();
            if (structure == null) continue;
            String name = structure.name;
            if (structure instanceof ISignalComponent && (com = (ISignalComponent)((Object)structure)).getComponentType() == SignalComponentType.INPUT) {
                list.add(new GuiSignalComponent(prefix + "i" + i, item.getTitle() + "." + (String)(name != null ? name : "i" + i), com, true, i));
            } else if (includeRelations) {
                this.gatherInputs(child, prefix + "c" + i + ".", list, includeRelations, false);
            }
            ++i;
        }
    }

    protected void gatherInputs(IGuiSignalStructure item, String prefix, List<GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
        IGuiSignalStructure iGuiSignalStructure;
        if (item == this.item) {
            this.addInput(item, "", list, includeRelations);
        }
        if (searchForParent && includeRelations && (iGuiSignalStructure = item.parent()) instanceof IGuiSignalStructure) {
            IGuiSignalStructure parent = iGuiSignalStructure;
            this.gatherInputs(parent, "p." + prefix, list, includeRelations, true);
            return;
        }
        if (item != this.item) {
            this.addInput(item, prefix, list, includeRelations);
        }
    }

    protected void addExternalOutputs(IGuiSignalStructure item, String prefix, List<GuiSignalComponent> list, boolean includeRelations) {
        int i = 0;
        for (IGuiSignalStructure child : item.children()) {
            ISignalComponent com;
            if (child == this.item) {
                ++i;
                continue;
            }
            LittleStructure structure = child.getStructure();
            if (structure == null) continue;
            String name = structure.name;
            if (structure instanceof ISignalComponent && (com = (ISignalComponent)((Object)structure)).getComponentType() == SignalComponentType.OUTPUT) {
                list.add(new GuiSignalComponent(prefix + "o" + i, item.getTitle() + "." + (String)(name != null ? name : "o" + i), com, true, i));
            } else if (includeRelations) {
                this.gatherOutputs(child, prefix + "c" + i + ".", list, includeRelations, false);
            }
            ++i;
        }
    }

    protected void addOutput(IGuiSignalStructure item, String prefix, List<GuiSignalComponent> list, boolean includeRelations) {
        LittleStructureType type = item.getStructureType();
        if (type != null && type.outputs != null) {
            for (int i = 0; i < type.outputs.size(); ++i) {
                list.add(new GuiSignalComponent(prefix + "b" + i, item.getTitle(), type.outputs.get(i), false, false, i));
            }
        }
        this.addExternalOutputs(item, prefix, list, includeRelations);
    }

    protected void gatherOutputs(IGuiSignalStructure item, String prefix, List<GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
        IGuiSignalStructure iGuiSignalStructure;
        if (item == this.item) {
            this.addOutput(item, "", list, includeRelations);
        }
        if (searchForParent && includeRelations && (iGuiSignalStructure = item.parent()) instanceof IGuiSignalStructure) {
            IGuiSignalStructure parent = iGuiSignalStructure;
            this.gatherOutputs(parent, "p." + prefix, list, includeRelations, searchForParent);
            return;
        }
        if (item != this.item) {
            this.addOutput(item, prefix, list, includeRelations);
        }
    }
}

