/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal;

import javax.annotation.Nullable;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.littletiles.common.gui.signal.GuiSignalController;
import team.creative.littletiles.common.gui.signal.GuiSignalNodeAnchor;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;

public record GuiSignalConnection(GuiSignalNode from, GuiSignalNodeAnchor fromAnchor, GuiSignalNode to, GuiSignalNodeAnchor toAnchor) {
    public GuiSignalConnection(GuiSignalNode from, GuiSignalNode to) {
        this(from, GuiSignalNodeAnchor.RIGHT, to, GuiSignalNodeAnchor.LEFT);
    }

    public static GuiSignalConnection connect(GuiSignalNode from, @Nullable GuiSignalNodeAnchor fromAnchor, GuiSignalNode to, @Nullable GuiSignalNodeAnchor toAnchor) {
        GuiSignalConnection connection = new GuiSignalConnection(from, fromAnchor != null ? fromAnchor : from.connectionAnchor(true, to), to, toAnchor != null ? toAnchor : to.connectionAnchor(false, from));
        from.connect(connection);
        to.connect(connection);
        return connection;
    }

    public static GuiSignalConnection connect(GuiSignalNode from, GuiSignalNode to) {
        GuiSignalConnection connection = new GuiSignalConnection(from, from.connectionAnchor(true, to), to, to.connectionAnchor(false, from));
        from.connect(connection);
        to.connect(connection);
        return connection;
    }

    public float fromX() {
        return this.fromAnchor.x(this.from) + (float)this.from.rect.getX();
    }

    public float fromY() {
        return this.fromAnchor.y(this.from) + (float)this.from.rect.getY();
    }

    public float toX() {
        return this.toAnchor.x(this.to) + (float)this.to.rect.getX();
    }

    public float toY() {
        return this.toAnchor.y(this.to) + (float)this.to.rect.getY();
    }

    public void disconnect(GuiSignalController controller) {
        this.from.disconnect(this);
        this.to.disconnect(this);
        controller.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)controller));
    }
}

