/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControlRect;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;
import team.creative.creativecore.common.util.type.itr.ConsecutiveIterator;
import team.creative.creativecore.common.util.type.itr.ConsecutiveListIterator;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.creativecore.common.util.type.itr.FilterListIterator;
import team.creative.creativecore.common.util.type.itr.NestedIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.GuiSignalNodeAnchor;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignal;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeComparator;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeGate;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeInput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeNotOperator;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeOperator;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeOutput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeVirtualInput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeVirtualNumberInput;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.input.SignalInputVariable;
import team.creative.littletiles.common.structure.signal.logic.SignalInputConditionGate;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicComparator;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;

public class GuiSignalController
extends GuiParent {
    protected int cellWidth = 60;
    protected int cellHeight = 40;
    public SmoothValue scrolledX = new SmoothValue(200L);
    public SmoothValue scrolledY = new SmoothValue(200L);
    public SmoothValue zoom = new SmoothValue(200L, 1.0);
    public double startScrollX;
    public double startScrollY;
    public int dragX;
    public int dragY;
    public boolean scrolling;
    private List<List<GuiControl>> grid = new ArrayList<List<GuiControl>>();
    public final List<GuiSignalComponent> inputs;
    private GuiSignalNodeOutput output;
    private GuiSignalNode dragged;
    private boolean startedDragging = false;
    private GuiSignalNode selected;
    private GuiSignalNodeAnchor selectedAnchor;
    private Rect controllerRect;

    public GuiSignalController(String name, GuiSignalComponent output, List<GuiSignalComponent> inputs) {
        super(name);
        this.inputs = inputs;
        this.setOutput(4, output, null);
    }

    public double getOffsetX() {
        return -this.scrolledX.current();
    }

    public double getOffsetY() {
        return -this.scrolledY.current();
    }

    public Iterator<GuiControl> iterator() {
        return new ConsecutiveIterator(new Iterator[]{this.hoverControls.iterator(), this.controls.iterator(), FilterIterator.skipNull((Iterator)new NestedIterator(this.grid))});
    }

    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(GuiGraphics graphics, Rect contentRect, Rect realContentRect, double scale, int mouseX, int mouseY) {
        if (realContentRect == null) {
            return;
        }
        this.scrolledX.tick();
        this.scrolledY.tick();
        this.zoom.tick();
        this.setScale(this.zoom.current());
        float controlScale = (float)this.scaleFactor();
        scale *= this.scaleFactor();
        double xOffset = this.getOffsetX();
        double yOffset = this.getOffsetY();
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.scale(controlScale, controlScale, 1.0f);
        this.controllerRect = realContentRect;
        this.renderControls(graphics, contentRect, realContentRect, mouseX, mouseY, (ListIterator)FilterListIterator.skipNull((ListIterator)new ConsecutiveListIterator(this.grid).goEnd()), scale, xOffset, yOffset, false);
        this.controllerRect = null;
        pose.popPose();
        super.renderContent(graphics, contentRect, realContentRect, scale, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    protected void renderControl(GuiGraphics graphics, GuiControl control, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY, boolean hover) {
        if (control instanceof GuiSignalNode) {
            GuiSignalNode com = (GuiSignalNode)control;
            this.controllerRect.scissor();
            RenderSystem.disableDepthTest();
            if (com.hasUnderline()) {
                Font font = GuiRenderHelper.getFont();
                String underline = com.getUnderline();
                graphics.drawString(font, underline, control.rect.getWidth() / 2 - font.width(underline) / 2, control.rect.getHeight() + 4, -1);
            }
            this.renderConnections(graphics.pose().last().pose(), com, scale, realRect.inside((double)mouseX, (double)mouseY), mouseX, mouseY);
            RenderSystem.enableDepthTest();
            realRect.scissor();
        }
        super.renderControl(graphics, control, controlRect, realRect, scale, mouseX, mouseY, hover);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    private void renderConnections(Matrix4f matrix, GuiSignalNode node, double scale, boolean hover, double mouseX, double mouseY) {
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)((float)(2.0 * scale)));
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        float originX = node.rect.getX() - this.getContentOffset();
        float originY = node.rect.getY() - this.getContentOffset();
        for (GuiSignalConnection connection : node.toConnections()) {
            GuiSignalNode other = connection.from();
            if (!hover) {
                hover = other.toScreenRect(new Rect(0.0, 0.0, (double)((GuiControl)other).rect.getWidth(), (double)((GuiControl)other).rect.getHeight())).inside(mouseX, mouseY);
            }
            this.renderConnection(matrix, connection, hover, originX, originY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    private void renderConnection(Matrix4f matrix, GuiSignalConnection connection, boolean hover, float originX, float originY) {
        int color = hover ? -1 : -16777216;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        builder.addVertex(matrix, connection.fromX() - originX, connection.fromY() - originY, 0.0f).setColor(color).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(matrix, connection.toX() - originX, connection.toY() - originY, 0.0f).setColor(color).setNormal(1.0f, 0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    private void flowCell(GuiControlRect child, int x, int y) {
        if (this.getParent() == null) {
            return;
        }
        int widthNode = Math.min(this.cellWidth, child.getPreferredWidth(this.cellWidth));
        child.setWidth(widthNode, this.cellWidth);
        child.setX(this.cellWidth * x + this.cellWidth / 2 - child.getWidth() / 2);
        child.flowX();
        int heightNode = Math.min(this.cellHeight, child.getPreferredHeight(this.cellHeight));
        child.setHeight(heightNode, this.cellHeight);
        child.setY(this.cellHeight * y + this.cellHeight / 2 - child.getHeight() / 2);
        child.flowY();
    }

    public void flowX(int width, int preferred) {
        super.flowX(width, preferred);
        for (int x = 0; x < this.grid.size(); ++x) {
            List<GuiControl> rows = this.grid.get(x);
            for (int y = 0; y < rows.size(); ++y) {
                GuiControl child = rows.get(y);
                if (child == null) continue;
                int widthNode = Math.min(this.cellWidth, child.rect.getPreferredWidth(this.cellWidth));
                child.rect.setWidth(widthNode, this.cellWidth);
                child.rect.setX(this.cellWidth * x + this.cellWidth / 2 - child.rect.getWidth() / 2);
                child.rect.flowX();
            }
        }
    }

    public void flowY(int width, int height, int preferred) {
        super.flowX(width, preferred);
        for (int x = 0; x < this.grid.size(); ++x) {
            List<GuiControl> rows = this.grid.get(x);
            for (int y = 0; y < rows.size(); ++y) {
                GuiControl child = rows.get(y);
                if (child == null) continue;
                int heightNode = Math.min(this.cellHeight, child.rect.getPreferredHeight(this.cellHeight));
                child.rect.setHeight(heightNode, this.cellHeight);
                child.rect.setY(this.cellHeight * y + this.cellHeight / 2 - child.rect.getHeight() / 2);
                child.rect.flowY();
            }
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.startedDragging = false;
        if (button == 2) {
            this.zoom.set(1.0);
            this.scrolledX.set(0.0);
            this.scrolledY.set(0.0);
            return true;
        }
        if (!super.mouseClicked(x, y, button)) {
            this.select(null, null);
            this.scrolling = true;
            this.dragX = (int)x;
            this.dragY = (int)y;
            this.startScrollX = this.scrolledX.current();
            this.startScrollY = this.scrolledY.current();
        }
        return true;
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        if (!super.mouseScrolled(x, y, delta)) {
            this.zoom.set(Mth.clamp((double)(this.zoom.aimed() + delta * 0.2), (double)0.1, (double)2.0));
        }
        return true;
    }

    public void mouseDragged(double x, double y, int button, double dragX, double dragY, double time) {
        super.mouseDragged(x, y, button, dragX, dragY, time);
        if (time > 0.2 && this.dragged != null) {
            this.set(this.dragged, (int)Math.max(0.0, (x * this.scaleFactorInv() + this.scrolledX.current()) / (double)this.cellWidth), (int)Math.max(0.0, (y * this.scaleFactorInv() + this.scrolledY.current()) / (double)this.cellHeight));
            this.startedDragging = true;
        }
    }

    public void mouseMoved(double x, double y) {
        if (this.scrolling) {
            this.scrolledX.set(Mth.clamp((double)((double)this.dragX - x + this.startScrollX), (double)-40.0, (double)(this.sizeX() * this.cellWidth)));
            this.scrolledY.set(Mth.clamp((double)((double)this.dragY - y + this.startScrollY), (double)-40.0, (double)(this.sizeY() * this.cellHeight)));
        }
        super.mouseMoved(x, y);
    }

    public void mouseReleased(double x, double y, int button) {
        super.mouseReleased(x, y, button);
        this.scrolling = false;
        if (this.dragged != null && !this.startedDragging) {
            this.select(this.dragged, this.selectedAnchor);
        }
        this.startedDragging = false;
        this.dragged = null;
    }

    public void setOutput(int cell, GuiSignalComponent output, @Nullable SignalInputCondition.SignalPosition position) {
        if (this.output != null) {
            this.output.remove();
        }
        this.output = new GuiSignalNodeOutput(output, position);
        if (position == null) {
            this.setToFreeCell(cell, this.output);
        } else {
            this.set(this.output, position.x(), position.y());
        }
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public void setCondition(@Nullable SignalInputCondition.SignalPosition outputPosition, SignalInputCondition condition, GuiDialogSignal signal) {
        this.reset();
        try {
            ArrayList<List<GuiSignalNode>> parsed = new ArrayList<List<GuiSignalNode>>();
            GuiSignalNode node = this.fill(condition, signal, parsed, 0);
            for (int i = parsed.size() - 1; i >= 0; --i) {
                List rows = (List)parsed.get(i);
                for (int j = rows.size() - 1; j >= 0; --j) {
                    GuiSignalNode signalNode = (GuiSignalNode)((Object)rows.get(j));
                    if (signalNode.x() == -1) {
                        this.set(signalNode, parsed.size() - i - 1, rows.size() - j - 1);
                        continue;
                    }
                    this.set(signalNode, signalNode.x(), signalNode.y());
                }
            }
            this.setOutput(parsed.size(), this.output.component, outputPosition);
            GuiSignalConnection connection = new GuiSignalConnection(node, this.output);
            node.connect(connection);
            this.output.connect(connection);
            return;
        }
        catch (ParseException e) {
            LittleTiles.LOGGER.catching((Throwable)e);
            this.reset();
            this.setOutput(4, this.output.component, outputPosition);
            return;
        }
    }

    private GuiSignalNode fill(SignalInputCondition condition, GuiDialogSignal signal, List<List<GuiSignalNode>> parsed, int level) throws ParseException {
        GuiSignalNode node;
        if (condition instanceof SignalInputCondition.SignalInputConditionNot || condition instanceof SignalInputCondition.SignalInputConditionNotBitwise) {
            boolean bitwise = condition instanceof SignalInputCondition.SignalInputConditionNotBitwise;
            node = new GuiSignalNodeNotOperator(bitwise, condition.position);
            GuiSignalNode child = this.fill(bitwise ? ((SignalInputCondition.SignalInputConditionNotBitwise)condition).condition : ((SignalInputCondition.SignalInputConditionNot)condition).condition, signal, parsed, level + 1);
            GuiSignalConnection connection = new GuiSignalConnection(child, node);
            node.connect(connection);
            child.connect(connection);
        } else if (condition instanceof SignalLogicOperator.SignalInputConditionOperatorStackable) {
            SignalLogicOperator.SignalInputConditionOperatorStackable stack = (SignalLogicOperator.SignalInputConditionOperatorStackable)condition;
            node = new GuiSignalNodeOperator(stack.operator(), stack.position);
            for (SignalInputCondition subCondition : stack.conditions) {
                child = this.fill(subCondition, signal, parsed, level + 1);
                GuiSignalConnection connection = new GuiSignalConnection(child, node);
                node.connect(connection);
                child.connect(connection);
            }
        } else if (condition instanceof SignalInputVariable) {
            SignalInputVariable in = (SignalInputVariable)condition;
            node = new GuiSignalNodeInput(in, signal.getInput(in.target), in.position);
        } else if (condition instanceof SignalInputCondition.SignalInputVirtualVariable) {
            SignalInputCondition.SignalInputVirtualVariable variable = (SignalInputCondition.SignalInputVirtualVariable)condition;
            node = new GuiSignalNodeVirtualInput(variable, variable.position);
        } else if (condition instanceof SignalInputCondition.SignalInputVirtualNumber) {
            SignalInputCondition.SignalInputVirtualNumber number = (SignalInputCondition.SignalInputVirtualNumber)condition;
            node = new GuiSignalNodeVirtualNumberInput(number, number.position);
        } else if (condition instanceof SignalLogicComparator.SignalInputConditionComparator) {
            SignalLogicComparator.SignalInputConditionComparator com = (SignalLogicComparator.SignalInputConditionComparator)condition;
            node = new GuiSignalNodeComparator(com.comparator, com.position);
            for (SignalInputCondition subCondition : com.conditions) {
                child = this.fill(subCondition, signal, parsed, level + 1);
                GuiSignalConnection.connect(child, node);
            }
        } else if (condition instanceof SignalInputConditionGate) {
            SignalInputConditionGate gate = (SignalInputConditionGate)condition;
            node = new GuiSignalNodeGate(gate.invert, gate.position);
            GuiSignalNode child = this.fill(gate.gate, signal, parsed, level + 1);
            GuiSignalConnection.connect(child, null, node, GuiSignalNodeGate.UPPER_BOTTOM);
            child = this.fill(gate.through, signal, parsed, level + 1);
            GuiSignalConnection.connect(child, null, node, GuiSignalNodeAnchor.LEFT);
        } else {
            throw new ParseException("Invalid condition type", 0);
        }
        while (parsed.size() <= level) {
            parsed.add(new ArrayList());
        }
        parsed.get(level).add(node);
        return node;
    }

    public GuiSignalNodeVirtualInput addVirtualInput() {
        return this.setToFreeCell(0, new GuiSignalNodeVirtualInput(null));
    }

    public GuiSignalNodeVirtualNumberInput addVirtualNumberInput() {
        return this.setToFreeCell(0, new GuiSignalNodeVirtualNumberInput(null));
    }

    public GuiSignalNodeInput addInput(GuiSignalComponent input) {
        return this.setToFreeCell(0, new GuiSignalNodeInput(input, null));
    }

    public GuiSignalNodeNotOperator addNotOperator(boolean bitwise) {
        return this.setToFreeCell(1, new GuiSignalNodeNotOperator(bitwise, null));
    }

    public GuiSignalNodeOperator addOperator(SignalLogicOperator operator) {
        return this.setToFreeCell(1, new GuiSignalNodeOperator(operator, null));
    }

    public GuiSignalNodeComparator addComparator(SignalLogicComparator comparator) {
        return this.setToFreeCell(1, new GuiSignalNodeComparator(comparator, null));
    }

    public GuiSignalNodeGate addGate(boolean invert) {
        return this.setToFreeCell(1, new GuiSignalNodeGate(invert, null));
    }

    public GuiSignalNode selected() {
        return this.selected;
    }

    public void drag(GuiSignalNode node, @Nullable GuiSignalNodeAnchor anchor) {
        this.dragged = node;
        this.selectedAnchor = anchor;
    }

    public void select(GuiSignalNode node, @Nullable GuiSignalNodeAnchor anchor) {
        if (this.selected != null) {
            this.selected.setDefaultColor(-1);
        }
        this.selected = node;
        this.selectedAnchor = anchor;
        if (this.selected != null) {
            this.selected.setDefaultColor(-256);
        }
    }

    public void selectOrConnect(GuiSignalNode node, GuiSignalNodeAnchor anchor, boolean shouldDrag) {
        if (this.selected() != null) {
            this.tryToggleConnectionToSelected(node, anchor);
        } else if (shouldDrag) {
            this.drag(node, anchor);
        } else {
            this.select(node, anchor);
        }
    }

    public void tryToggleConnectionToSelected(GuiSignalNode node, GuiSignalNodeAnchor anchor) {
        if (this.selected != node) {
            GuiSignalConnection connection = this.selected.getConnectionTo(node);
            if (connection != null) {
                connection.disconnect(this);
                this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
            } else if (this.selected.canConnectTo(node, this.selectedAnchor) && node.canConnectFrom(this.selected, anchor)) {
                GuiSignalConnection.connect(this.selected, this.selectedAnchor, node, anchor);
                this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
            }
        }
        this.select(null, null);
    }

    public SignalInputCondition generatePattern() throws GeneratePatternException {
        return this.output.generateCondition(new ArrayList<GuiSignalNode>());
    }

    public SignalInputCondition.SignalPosition outputPosition() {
        return this.output.position();
    }

    public <T extends GuiSignalNode> T setToFreeCell(int startCol, T node) {
        for (int i = 0; i < 50 - startCol; ++i) {
            if (this.grid.size() <= i) {
                this.grid.add(new ArrayList());
            }
            if (i < startCol) continue;
            List<GuiControl> rows = this.grid.get(i);
            for (int j = 0; j < 50; ++j) {
                if (rows.size() <= j) {
                    rows.add(null);
                }
                if (rows.get(j) != null) continue;
                this.set(node, i, j);
                return node;
            }
        }
        throw new RuntimeException("There are no empty cells left");
    }

    public int sizeX() {
        return this.grid.size();
    }

    public int sizeY() {
        int rows = 0;
        for (int i = 0; i < this.grid.size(); ++i) {
            rows = Math.max(rows, this.grid.get(i).size());
        }
        return rows;
    }

    public void removeNode(GuiSignalNode node) {
        if (this.selected != null) {
            this.selected.setDefaultColor(-1);
        }
        this.selected = null;
        this.dragged = null;
        this.remove(node.x(), node.y());
        node.remove();
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public GuiControl remove(int col, int row) {
        List<GuiControl> rows;
        if (col < this.grid.size() && row < (rows = this.grid.get(col)).size()) {
            return rows.set(row, null);
        }
        return null;
    }

    public void set(GuiSignalNode node, int col, int row) {
        boolean added = node.added();
        node.setParent((IGuiParent)this);
        if (added && node.x() == col && node.y() == row) {
            return;
        }
        while (this.grid.size() <= col) {
            this.grid.add(new ArrayList());
        }
        List<GuiControl> rows = this.grid.get(col);
        while (rows.size() <= row) {
            rows.add(null);
        }
        if (rows.get(row) == null) {
            GuiSignalNode child = null;
            if (added) {
                child = this.remove(node.x(), node.y());
            }
            if (child == null) {
                child = node;
            }
            rows.set(row, (GuiControl)child);
            node.updatePosition(col, row);
            this.flowCell(((GuiControl)child).rect, col, row);
        }
    }

    public void reset() {
        this.controls.clear();
        this.grid.clear();
        this.output.remove();
        this.dragged = null;
        this.selected = null;
    }
}

