/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.gui.signal.GuiComponentSearch;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.IGuiSignalStructure;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalEvents;
import team.creative.littletiles.common.packet.structure.StructureOutputConfigurationChanged;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;
import team.creative.littletiles.common.structure.signal.output.SignalExternalOutputHandler;

public class GuiSignalStructurePlaced
implements IGuiSignalStructure {
    private IGuiSignalStructure parent;
    private final List<IGuiSignalStructure> children;
    public final LittleStructure structure;
    protected GuiComponentSearch signalSearch;
    protected GuiDialogSignalEvents.GuiSignalEvent[] internalOutputs;
    protected HashMap<Integer, GuiDialogSignalEvents.GuiSignalEvent> externalOutputs;

    public GuiSignalStructurePlaced(LittleStructure structure, boolean main, boolean lookForParent) {
        this.structure = structure;
        if (this.structure.hasParent() && lookForParent) {
            try {
                this.parent = new GuiSignalStructurePlaced(structure.getParent().getStructure(), false, true);
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        } else {
            this.parent = null;
        }
        this.children = new ArrayList<IGuiSignalStructure>();
        for (StructureChildConnection s : structure.children.all()) {
            try {
                this.children.add(new GuiSignalStructurePlaced(s.getStructure(), false, false));
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
        if (main) {
            this.signalSearch = new GuiComponentSearch(this);
            GuiSignalComponent[] internal = this.signalSearch.internalOutputs();
            if (internal != null) {
                this.internalOutputs = new GuiDialogSignalEvents.GuiSignalEvent[internal.length];
                for (int i = 0; i < internal.length; ++i) {
                    this.internalOutputs[i] = structure == null ? new GuiDialogSignalEvents.GuiSignalEvent(internal[i], (InternalSignalOutput)null) : new GuiDialogSignalEvents.GuiSignalEvent(internal[i], structure.getOutput(i));
                }
            } else {
                this.internalOutputs = null;
            }
            this.externalOutputs = new HashMap();
            for (GuiSignalComponent output : this.signalSearch.externalOutputs()) {
                if (structure == null) {
                    this.externalOutputs.put(output.index(), new GuiDialogSignalEvents.GuiSignalEvent(output, (InternalSignalOutput)null));
                    continue;
                }
                if (!output.external()) continue;
                this.externalOutputs.put(output.index(), new GuiDialogSignalEvents.GuiSignalEvent(output, structure.getExternalOutput(output.index())));
            }
        }
    }

    @Override
    public GuiComponentSearch getSignalSearch() {
        return this.signalSearch;
    }

    @Override
    public GuiDialogSignalEvents.GuiSignalEvent[] internalOutputs() {
        return this.internalOutputs;
    }

    @Override
    public Iterable<GuiDialogSignalEvents.GuiSignalEvent> externalOutputs() {
        return this.externalOutputs.values();
    }

    public void setInternalOutput(int index, GuiDialogSignalEvents.GuiSignalEvent event) {
        if (this.internalOutputs != null && index >= 0 && index < this.internalOutputs.length) {
            this.internalOutputs[index] = event;
        }
    }

    public void setExternalOutput(int index, GuiDialogSignalEvents.GuiSignalEvent event) {
        this.externalOutputs.put(index, event);
    }

    @Override
    public void setSignalOutputs(List<GuiDialogSignalEvents.GuiSignalEvent> events) {
        for (GuiDialogSignalEvents.GuiSignalEvent event : events) {
            this.setSignalOutput(event.component.external(), event.component.index(), event);
        }
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (int i = 0; i < this.internalOutputs.length; ++i) {
            GuiDialogSignalEvents.GuiSignalEvent event = this.internalOutputs[i];
            InternalSignalOutput output = this.structure.getOutput(i);
            output.condition = event.condition;
            output.handler = event.getHandler(output, this.structure);
            output.outputPosition = event.outputPostion;
            list.add((Object)output.saveConfiguration(true, new CompoundTag()));
        }
        nbt.put("internal", (Tag)list);
        CompoundTag external = new CompoundTag();
        for (GuiDialogSignalEvents.GuiSignalEvent event : this.externalOutputs.values()) {
            external.put("" + event.component.index(), (Tag)new SignalExternalOutputHandler(null, event.component.index(), event.condition, x -> event.getHandler((ISignalComponent)x, this.structure), event.outputPostion).write(true));
        }
        nbt.put("external", (Tag)external);
        LittleTiles.NETWORK.sendToServer((CreativePacket)new StructureOutputConfigurationChanged(this.structure.getStructureLocation(), nbt));
    }

    @Nullable
    public void setSignalOutput(boolean external, int index, GuiDialogSignalEvents.GuiSignalEvent event) {
        if (external) {
            this.setExternalOutput(index, event);
        } else {
            this.setInternalOutput(index, event);
        }
    }

    @Override
    public LittleStructureType getStructureType() {
        return this.structure.type;
    }

    @Override
    public String getTitle() {
        int index;
        int n = index = this.structure.hasParent() ? this.structure.getParent().childId : 0;
        if (this.structure.name == null) {
            return this.structure.type.id + " " + index;
        }
        return this.structure.name;
    }

    @Override
    public LittleStructure getStructure() {
        return this.structure;
    }

    @Override
    public Iterable<IGuiSignalStructure> children() {
        return this.children;
    }

    @Override
    public IGuiSignalStructure parent() {
        return this.parent;
    }
}

