/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.dialog;

import java.text.ParseException;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.control.simple.GuiTabButton;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNodeInput;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;
import team.creative.littletiles.common.structure.signal.logic.SignalPatternParser;
import team.creative.littletiles.common.structure.signal.logic.SignalTarget;

public class GuiDialogSignalInput
extends GuiLayer {
    public GuiSignalNodeInput input;
    public int bandwidth;

    public GuiDialogSignalInput() {
        super("gui.dialog.signal.input", 200, 100);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(this::changed);
    }

    public void init(GuiSignalNodeInput input) {
        this.input = input;
        super.init();
    }

    public void create() {
        if (this.input == null) {
            return;
        }
        GuiParent upper = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)upper);
        upper.add((GuiControl)new GuiLabel("start").setTitle((Component)Component.literal((String)(this.input.component.name() + "["))));
        upper.add((GuiControl)new GuiTextfield("range", this.input.getRange()).setDim(100));
        upper.add((GuiControl)new GuiLabel("result").setTitle((Component)Component.literal((String)("] " + this.input.component.bandwidth() + " ->"))));
        ArrayList<GuiSignalInputOperator> modes = new ArrayList<GuiSignalInputOperator>();
        modes.add(new GuiSignalInputOperator(this, "none"){

            @Override
            public void load(GuiSignalNodeInput input, GuiParent panel) {
            }

            @Override
            public void save(GuiSignalNodeInput input, GuiParent panel) {
            }
        });
        modes.add(new GuiSignalInputOperator(this, "operation"){

            @Override
            public void load(GuiSignalNodeInput input, GuiParent panel) {
                panel.add((GuiControl)new GuiStateButton("operation", (Object)(input.logic == null ? SignalLogicOperator.AND : input.logic), (IComponentMap)new TextMapBuilder().addComponent(SignalLogicOperator.NON_BITWISE_OPERATORS, x -> Component.literal((String)x.display))));
            }

            @Override
            public void save(GuiSignalNodeInput input, GuiParent panel) {
                input.logic = (SignalLogicOperator)((GuiStateButton)panel.get("operation")).selected();
            }
        });
        modes.add(new GuiSignalInputOperator("pattern"){

            @Override
            public void load(GuiSignalNodeInput input, GuiParent panel) {
                for (int i = 0; i < GuiDialogSignalInput.this.bandwidth; ++i) {
                    GuiParent line = new GuiParent((GuiFlow)GuiFlow.STACK_X);
                    panel.add(line.setExpandableX());
                    int state = 2;
                    if (input.pattern != null && input.pattern.length > i) {
                        state = input.pattern[i];
                    }
                    line.add((GuiControl)new GuiLabel("label" + i).setTitle((Component)Component.literal((String)(i + ":"))));
                    line.add((GuiControl)new GuiStateButton("" + i, state, (IComponentMap)new TextMapBuilder().addComponent((Object)0, (Component)Component.translatable((String)"gui.false")).addComponent((Object)1, (Component)Component.translatable((String)"gui.true")).addComponent((Object)2, (Component)Component.translatable((String)"gui.ignore"))));
                }
            }

            @Override
            public void save(GuiSignalNodeInput input, GuiParent panel) {
                int[] indexes = new int[GuiDialogSignalInput.this.bandwidth];
                for (int i = 0; i < GuiDialogSignalInput.this.bandwidth; ++i) {
                    GuiStateButton stateButton = (GuiStateButton)panel.get("" + i);
                    indexes[i] = (Integer)stateButton.selected();
                }
                input.pattern = indexes;
            }
        });
        modes.add(new GuiSignalInputOperator("equation"){

            @Override
            public void load(GuiSignalNodeInput input, GuiParent panel) {
                GuiParent line = new GuiParent((GuiFlow)GuiFlow.STACK_X);
                panel.add(line.setExpandableX());
                line.add((GuiControl)new GuiLabel("label").setTitle((Component)Component.literal((String)"d<index>")));
                line.add((GuiControl)new GuiTextfield("equation", input.equation != null ? input.equation.write() : "").setDim(100));
            }

            @Override
            public void save(GuiSignalNodeInput input, GuiParent panel) {
                GuiTextfield textfield = (GuiTextfield)GuiDialogSignalInput.this.get("equation");
                try {
                    input.equation = SignalInputCondition.parseExpression(new SignalPatternParser(textfield.getText()), new char[0], false, true);
                }
                catch (ParseException e) {
                    input.equation = null;
                }
            }
        });
        this.add((GuiControl)new GuiTabButton("type", this.input.operator, (IComponentMap)new TextMapBuilder().addComponent(modes, x -> x.translatable())));
        this.add((GuiControl)new GuiScrollY("config").setExpandable());
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            GuiTextfield range = (GuiTextfield)this.get("range");
            try {
                this.input.indexes = this.parseRange(range.getText());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            GuiTabButton tab = (GuiTabButton)this.get("type");
            GuiScrollY panel = (GuiScrollY)this.get("config");
            this.input.operator = tab.index();
            ((GuiSignalInputOperator)tab.selected()).save(this.input, (GuiParent)panel);
            this.input.updateLabel();
            this.closeTopLayer();
        }).setTranslate("gui.save"));
        this.updateBandwidth();
    }

    public void changed(GuiControlChangedEvent event) {
        if (event.control.is("type")) {
            GuiTabButton tab = (GuiTabButton)this.get("type");
            GuiScrollY panel = (GuiScrollY)this.get("config");
            panel.clear();
            ((GuiSignalInputOperator)tab.selected()).load(this.input, (GuiParent)panel);
            tab.reflow();
        } else if (event.control.is("range")) {
            this.updateBandwidth();
        }
    }

    public void updateBandwidth() {
        GuiTextfield range = (GuiTextfield)this.get("range");
        try {
            SignalTarget.SignalCustomIndex[] indexes = this.parseRange(range.getText());
            if (indexes == null) {
                this.bandwidth = this.input.component.bandwidth();
            } else {
                this.bandwidth = 0;
                for (int i = 0; i < indexes.length; ++i) {
                    this.bandwidth += indexes[i].length();
                }
            }
        }
        catch (ParseException e) {
            this.bandwidth = this.input.component.bandwidth();
        }
        GuiLabel result = (GuiLabel)this.get("result");
        result.setTitle((Component)Component.literal((String)("] " + this.input.component.bandwidth() + " -> " + this.bandwidth)));
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent(this.get("type")));
    }

    private SignalTarget.SignalCustomIndex[] parseRange(String range) throws ParseException {
        SignalPatternParser parser = new SignalPatternParser(range);
        ArrayList<SignalTarget.SignalCustomIndex> indexes = new ArrayList<SignalTarget.SignalCustomIndex>();
        while (parser.hasNext()) {
            indexes.add(SignalTarget.parseIndex(parser));
            if (parser.hasNext() && parser.next(true) == ',') continue;
        }
        if (indexes.isEmpty()) {
            return null;
        }
        return indexes.toArray(new SignalTarget.SignalCustomIndex[indexes.size()]);
    }

    public abstract class GuiSignalInputOperator {
        public final String name;

        public GuiSignalInputOperator(GuiDialogSignalInput this$0, String name) {
            this.name = name;
        }

        public abstract void load(GuiSignalNodeInput var1, GuiParent var2);

        public abstract void save(GuiSignalNodeInput var1, GuiParent var2);

        public Component translatable() {
            return Component.translatable((String)("gui.signal.configuration.input.operation.type." + this.name));
        }
    }
}

