/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.node;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.GuiSignalController;
import team.creative.littletiles.common.gui.signal.GuiSignalNodeAnchor;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;

public abstract class GuiSignalNode
extends GuiParent {
    private int x = -1;
    private int y = -1;
    private boolean added = false;
    public GuiButton button;

    public GuiSignalNode(String caption, @Nullable SignalInputCondition.SignalPosition position) {
        if (position != null) {
            this.x = position.x();
            this.y = position.y();
        }
        this.beforeAddingButton();
        this.button = new GuiButton(caption, x -> {
            GuiSignalController controller = this.controller();
            if (x == 1 && this.removable()) {
                controller.removeNode(this);
                return;
            }
            controller.selectOrConnect(this, this.buttonAnchor(), x == 0);
        });
        this.add((GuiControl)this.button);
        this.button.setTitle((Component)Component.literal((String)caption));
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.CENTER;
    }

    protected GuiSignalNodeAnchor buttonAnchor() {
        return null;
    }

    protected void beforeAddingButton() {
    }

    public boolean hasUnderline() {
        return false;
    }

    public String getUnderline() {
        return null;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public SignalInputCondition.SignalPosition position() {
        return new SignalInputCondition.SignalPosition(this.x, this.y);
    }

    public void updatePosition(int col, int row) {
        this.x = col;
        this.y = row;
        this.added = true;
    }

    public boolean added() {
        return this.added;
    }

    public GuiSignalController controller() {
        return (GuiSignalController)this.getParent();
    }

    public void reset() {
        this.setTooltip(null);
        this.button.setDefaultColor(-1);
    }

    public void setError(String error) {
        this.setTooltip(error);
        this.button.setDefaultColor(-65536);
    }

    public boolean testForDoubleClick(double x, double y, int button) {
        return button != 1;
    }

    public boolean removable() {
        return true;
    }

    public abstract SignalInputCondition generateCondition(List<GuiSignalNode> var1) throws GeneratePatternException;

    public abstract void disconnect(GuiSignalConnection var1);

    public abstract GuiSignalConnection getConnectionTo(GuiSignalNode var1);

    public abstract boolean canConnectTo(GuiSignalNode var1, @Nullable GuiSignalNodeAnchor var2);

    public abstract boolean canConnectFrom(GuiSignalNode var1, @Nullable GuiSignalNodeAnchor var2);

    public abstract void connect(GuiSignalConnection var1);

    public abstract void remove();

    public abstract Iterable<GuiSignalConnection> toConnections();

    public GuiSignalNodeAnchor connectionAnchor(boolean from, GuiSignalNode other) {
        return from ? GuiSignalNodeAnchor.RIGHT : GuiSignalNodeAnchor.LEFT;
    }

    public void setDefaultColor(int white) {
        this.button.setDefaultColor(white);
    }
}

