/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.node;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.GuiSignalNodeAnchor;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalInputConditionGate;

public class GuiSignalNodeGate
extends GuiSignalNode {
    public final boolean invert;
    public GuiSignalConnection first;
    public GuiSignalConnection second;
    public List<GuiSignalConnection> to = new ArrayList<GuiSignalConnection>();
    public GuiParent upper;
    public static final GuiSignalNodeAnchor UPPER_BOTTOM = new GuiSignalNodeAnchor<GuiSignalNodeGate>(){

        @Override
        public float x(GuiSignalNodeGate node) {
            return node.upper.rect.centerX();
        }

        @Override
        public float y(GuiSignalNodeGate node) {
            return node.upper.rect.centerY();
        }
    };

    public GuiSignalNodeGate(boolean invert, SignalInputCondition.SignalPosition position) {
        super(invert ? "ngate" : "gate", position);
        this.invert = invert;
    }

    @Override
    protected void beforeAddingButton() {
        super.beforeAddingButton();
        this.upper = new GuiParent();
        this.add((GuiControl)this.upper.setScale(0.5));
        this.upper.add((GuiControl)new GuiButton("", x -> this.controller().selectOrConnect(this, UPPER_BOTTOM, false)).setTitle((Component)Component.literal((String)"if")));
    }

    @Override
    protected GuiSignalNodeAnchor buttonAnchor() {
        return GuiSignalNodeAnchor.LEFT;
    }

    @Override
    public GuiSignalNodeAnchor connectionAnchor(boolean from, GuiSignalNode other) {
        if (!from) {
            return this.first == null ? UPPER_BOTTOM : GuiSignalNodeAnchor.LEFT;
        }
        return super.connectionAnchor(from, other);
    }

    @Override
    public boolean canConnectTo(GuiSignalNode node, @Nullable GuiSignalNodeAnchor anchor) {
        for (GuiSignalConnection connectTo : this.to) {
            if (connectTo.to() != node) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canConnectFrom(GuiSignalNode node, @Nullable GuiSignalNodeAnchor anchor) {
        if (this.first != null && this.first.from() == node) {
            return false;
        }
        if (this.second != null && this.second.from() == node) {
            return false;
        }
        if (anchor == null) {
            return this.first == null || this.second == null;
        }
        if (anchor == UPPER_BOTTOM) {
            return this.first == null;
        }
        return this.second == null;
    }

    @Override
    public GuiSignalConnection getConnectionTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.to) {
            if (connectTo.to() != node) continue;
            return connectTo;
        }
        return null;
    }

    @Override
    public void disconnect(GuiSignalConnection connection) {
        if (connection.to() == this) {
            if (this.first == connection) {
                this.first = null;
            } else {
                this.second = null;
            }
        } else {
            this.to.remove(connection);
        }
    }

    @Override
    public Iterable<GuiSignalConnection> toConnections() {
        return this.to;
    }

    @Override
    public void connect(GuiSignalConnection connection) {
        if (connection.to() == this) {
            if (connection.toAnchor() == GuiSignalNodeAnchor.LEFT) {
                this.second = connection;
            } else {
                this.first = connection;
            }
        } else {
            this.to.add(connection);
        }
    }

    @Override
    public void remove() {
        if (this.first != null) {
            this.first.disconnect(this.controller());
        }
        if (this.second != null) {
            this.second.disconnect(this.controller());
        }
        for (GuiSignalConnection connection : new ArrayList<GuiSignalConnection>(this.to)) {
            connection.disconnect(this.controller());
        }
    }

    @Override
    public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
        this.reset();
        if (this.first == null && this.second == null) {
            throw new GeneratePatternException(this, "empty");
        }
        if (processed.contains((Object)this)) {
            throw new GeneratePatternException(this, "circular");
        }
        processed.add(this);
        ArrayList<SignalInputCondition> parsed = new ArrayList<SignalInputCondition>();
        if (this.first != null) {
            parsed.add(this.first.from().generateCondition(new ArrayList<GuiSignalNode>(processed)));
        }
        if (this.second != null) {
            parsed.add(this.second.from().generateCondition(new ArrayList<GuiSignalNode>(processed)));
        }
        if (parsed.isEmpty()) {
            throw new GeneratePatternException(this, "novalidchildren");
        }
        if (parsed.size() == 1) {
            return (SignalInputCondition)parsed.get(0);
        }
        return new SignalInputConditionGate((SignalInputCondition)parsed.get(0), this.invert, (SignalInputCondition)parsed.get(1), this.position());
    }
}

