/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.node;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.GuiSignalNodeAnchor;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;

public class GuiSignalNodeOperator
extends GuiSignalNode {
    public final SignalLogicOperator operator;
    private List<GuiSignalConnection> from = new ArrayList<GuiSignalConnection>();
    private List<GuiSignalConnection> to = new ArrayList<GuiSignalConnection>();

    public GuiSignalNodeOperator(SignalLogicOperator operator, @Nullable SignalInputCondition.SignalPosition position) {
        super(operator.display, position);
        this.operator = operator;
    }

    @Override
    public boolean canConnectTo(GuiSignalNode node, @Nullable GuiSignalNodeAnchor anchor) {
        for (GuiSignalConnection connectTo : this.to) {
            if (connectTo.to() != node) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canConnectFrom(GuiSignalNode node, @Nullable GuiSignalNodeAnchor anchor) {
        for (GuiSignalConnection connectFrom : this.from) {
            if (connectFrom.from() != node) continue;
            return false;
        }
        return true;
    }

    @Override
    public GuiSignalConnection getConnectionTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.to) {
            if (connectTo.to() != node) continue;
            return connectTo;
        }
        return null;
    }

    @Override
    public void disconnect(GuiSignalConnection connection) {
        if (connection.to() == this) {
            this.from.remove(connection);
        } else {
            this.to.remove(connection);
        }
    }

    @Override
    public Iterable<GuiSignalConnection> toConnections() {
        return this.to;
    }

    @Override
    public void connect(GuiSignalConnection connection) {
        if (connection.to() == this) {
            this.from.add(connection);
        } else {
            this.to.add(connection);
        }
    }

    @Override
    public void remove() {
        for (GuiSignalConnection connection : new ArrayList<GuiSignalConnection>(this.from)) {
            connection.disconnect(this.controller());
        }
        for (GuiSignalConnection connection : new ArrayList<GuiSignalConnection>(this.to)) {
            connection.disconnect(this.controller());
        }
    }

    @Override
    public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
        this.reset();
        if (this.from.isEmpty()) {
            throw new GeneratePatternException(this, "empty");
        }
        if (processed.contains((Object)this)) {
            throw new GeneratePatternException(this, "circular");
        }
        processed.add(this);
        if (this.from.size() == 1) {
            return this.from.get(0).from().generateCondition(processed);
        }
        ArrayList<SignalInputCondition> parsed = new ArrayList<SignalInputCondition>();
        for (int i = 0; i < this.from.size(); ++i) {
            try {
                parsed.add(this.from.get(i).from().generateCondition(new ArrayList<GuiSignalNode>(processed)));
                continue;
            }
            catch (GeneratePatternException generatePatternException) {
                // empty catch block
            }
        }
        if (parsed.isEmpty()) {
            throw new GeneratePatternException(this, "novalidchildren");
        }
        if (parsed.size() == 1) {
            return (SignalInputCondition)parsed.get(0);
        }
        return this.operator.create(parsed.toArray(new SignalInputCondition[parsed.size()]), this.position());
    }
}

