/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.node;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.gui.signal.GeneratePatternException;
import team.creative.littletiles.common.gui.signal.GuiSignalConnection;
import team.creative.littletiles.common.gui.signal.GuiSignalNodeAnchor;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalVirtualInput;
import team.creative.littletiles.common.gui.signal.node.GuiSignalNode;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;

public class GuiSignalNodeVirtualInput
extends GuiSignalNode {
    public List<GuiSignalConnection> tos = new ArrayList<GuiSignalConnection>();
    public SignalInputCondition[] conditions;

    public GuiSignalNodeVirtualInput(@Nullable SignalInputCondition.SignalPosition position) {
        super("v[]", null);
        this.conditions = new SignalInputCondition[0];
    }

    public GuiSignalNodeVirtualInput(SignalInputCondition.SignalInputVirtualVariable variable, @Nullable SignalInputCondition.SignalPosition position) throws ParseException {
        super("v[]", null);
        this.conditions = variable.conditions;
        this.updateLabel();
    }

    public void updateLabel() {
        Object conditionsText = "";
        for (int i = 0; i < this.conditions.length; ++i) {
            if (i > 0) {
                conditionsText = (String)conditionsText + ",";
            }
            conditionsText = (String)conditionsText + this.conditions[i].write();
        }
        if (((String)conditionsText).length() > 10) {
            conditionsText = "...";
        }
        this.button.setTitle((Component)Component.literal((String)("v[" + (String)conditionsText + "]")));
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this.controller()));
    }

    public boolean mouseDoubleClicked(double x, double y, int button) {
        ((GuiDialogSignalVirtualInput)LittleTilesGuiRegistry.VIRTUAL_INPUT_DIALOG.open(this.getIntegratedParent(), new CompoundTag())).init(this.controller().inputs, this);
        return true;
    }

    @Override
    public boolean canConnectTo(GuiSignalNode node, @Nullable GuiSignalNodeAnchor anchor) {
        for (GuiSignalConnection connectTo : this.tos) {
            if (connectTo.to() != node) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canConnectFrom(GuiSignalNode node, @Nullable GuiSignalNodeAnchor anchor) {
        return false;
    }

    @Override
    public GuiSignalConnection getConnectionTo(GuiSignalNode node) {
        for (GuiSignalConnection connectTo : this.tos) {
            if (connectTo.to() != node) continue;
            return connectTo;
        }
        return null;
    }

    @Override
    public void disconnect(GuiSignalConnection connection) {
        this.tos.remove(connection);
    }

    @Override
    public void connect(GuiSignalConnection connection) {
        this.tos.add(connection);
    }

    @Override
    public Iterable<GuiSignalConnection> toConnections() {
        return this.tos;
    }

    @Override
    public void remove() {
        for (GuiSignalConnection connection : new ArrayList<GuiSignalConnection>(this.tos)) {
            connection.disconnect(this.controller());
        }
    }

    @Override
    public SignalInputCondition generateCondition(List<GuiSignalNode> processed) throws GeneratePatternException {
        this.reset();
        return new SignalInputCondition.SignalInputVirtualVariable(this.conditions, this.position());
    }
}

