/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.blueprint;

import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalEvents;
import team.creative.littletiles.common.gui.tool.blueprint.GuiBlueprint;
import team.creative.littletiles.common.gui.tool.blueprint.GuiTreeItemStructure;

public class GuiBlueprintMerge
extends GuiLayer {
    public GuiBlueprint blueprint;
    public GuiTreeItemStructure structure;

    public GuiBlueprintMerge() {
        super("gui.blueprint.merge");
        this.setDim((GuiSizeRule)new GuiSizeRule.GuiFixedDimension(150));
        this.flow = GuiFlow.STACK_Y;
    }

    public void init(GuiBlueprint blueprint) {
        this.blueprint = blueprint;
        this.structure = (GuiTreeItemStructure)blueprint.tree.selected();
        this.clear();
        this.init();
    }

    public boolean isParent(GuiTreeItemStructure item, GuiTreeItemStructure possibleParent) {
        if (possibleParent.getLevel() >= item.getLevel()) {
            return false;
        }
        if (item.getParentItem() == possibleParent) {
            return true;
        }
        GuiTreeItem guiTreeItem = item.getParentItem();
        if (guiTreeItem instanceof GuiTreeItemStructure) {
            GuiTreeItemStructure parent = (GuiTreeItemStructure)guiTreeItem;
            return this.isParent(parent, possibleParent);
        }
        return false;
    }

    public void create() {
        boolean isEmpty;
        if (this.structure == null) {
            return;
        }
        this.add((GuiControl)new GuiLabel("title").setTranslate("gui.blueprint.merge.title", new Object[]{this.structure.getTitle()}));
        TextMapBuilder map = new TextMapBuilder();
        this.blueprint.actionOnAllItems(x -> {
            if (this.structure == x || this.isParent(this.structure, (GuiTreeItemStructure)x)) {
                return;
            }
            Object prefix = "";
            for (int i = 1; i < x.getLevel(); ++i) {
                prefix = (String)prefix + "-";
            }
            map.addComponent(x, (Component)Component.literal((String)((String)prefix + x.getTitle())));
        });
        boolean bl = isEmpty = map.size() == 0;
        if (isEmpty) {
            map.addComponent(null, (Component)Component.translatable((String)"gui.blueprint.merge.not_found"));
        }
        GuiComboBox box = new GuiComboBox("box", (IComponentMap)map);
        this.add(box.setExpandableX().setEnabled(!isEmpty));
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addRight(new GuiButton("save", x -> {
            GuiTreeItemStructure selected = (GuiTreeItemStructure)box.selected();
            if (selected == null) {
                return;
            }
            if (this.isParent(this.structure, selected)) {
                GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"merge_failed", (Component)Component.translatable((String)"gui.blueprint.dialog.merge.failed", (Object[])new Object[]{selected.getTitle(), this.structure.getTitle()}), (g, b) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
            }
            this.blueprint.removeItem(selected);
            this.structure.group.add(selected.group);
            int size = this.structure.externalOutputCount();
            for (GuiDialogSignalEvents.GuiSignalEvent event : selected.externalOutputs()) {
                this.structure.setExternalOutput(event.component.index() + size, event);
            }
            for (GuiTreeItem child : selected.items()) {
                this.structure.addItem(child);
            }
            this.structure.refreshAnimation();
            this.blueprint.tree.updateTree();
            this.closeThisLayer();
        }).setTranslate("gui.save").setEnabled(!isEmpty));
    }
}

