/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.blueprint;

import java.util.Collections;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.control.tree.GuiTree;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.control.GuiDistanceControl;
import team.creative.littletiles.common.gui.control.animation.GuiAnimationPanel;
import team.creative.littletiles.common.gui.tool.blueprint.GuiBlueprint;
import team.creative.littletiles.common.gui.tool.blueprint.GuiTreeItemStructure;
import team.creative.littletiles.common.gui.tool.blueprint.test.BlueprintTest;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class GuiBlueprintMove
extends GuiLayer {
    public GuiBlueprint blueprint;
    public GuiTree tree;

    public GuiBlueprintMove() {
        super("gui.blueprint.move", 400, 200);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(x -> {
            if (x.control.is("modes")) {
                ((GuiBlueprintMoveMode)((Object)((Object)((GuiStateButton)x.control).selected()))).select(this.tree);
            }
        });
    }

    public void init(GuiBlueprint blueprint) {
        this.blueprint = blueprint;
        this.clear();
        this.init();
    }

    public void closed() {
        if (this.tree == null) {
            return;
        }
        for (GuiTreeItem item : this.tree.allItems()) {
            if (!(item instanceof GuiBlueprintMoveItem)) continue;
            GuiBlueprintMoveItem move = (GuiBlueprintMoveItem)item;
            move.structure.resetOffset();
        }
    }

    public void create() {
        if (this.blueprint == null) {
            return;
        }
        GuiParent upper = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)upper);
        GuiParent sidebar = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        upper.add(sidebar.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRatioRules().widthRatio(0.3f).maxWidth(100)).setExpandableY());
        this.tree = new GuiTree("tree").setRootVisibility(false);
        sidebar.add(this.tree.setExpandable());
        for (GuiTreeItem item : this.blueprint.tree.root().items()) {
            GuiBlueprintMoveItem child = new GuiBlueprintMoveItem(this.tree, (GuiTreeItemStructure)item);
            this.tree.root().addItem((GuiTreeItem)child);
            child.addChildren();
        }
        GuiStateButton modes = new GuiStateButton("modes", (IComponentMap)new TextMapBuilder().addComponent((Object[])GuiBlueprintMoveMode.values(), x -> x.title()));
        sidebar.add(modes.setExpandableX());
        GuiParent config = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.CENTER);
        upper.add(config.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRatioRules().widthRatio(0.3f)));
        config.add((GuiControl)new GuiDistanceControl("distance", LittleGrid.overallDefault(), 1));
        GuiParent row1 = new GuiParent();
        config.add((GuiControl)row1);
        row1.add((GuiControl)new GuiBlueprintMoveButton(this, Facing.EAST));
        row1.add((GuiControl)new GuiBlueprintMoveButton(this, Facing.UP));
        row1.add((GuiControl)new GuiBlueprintMoveButton(this, Facing.SOUTH));
        GuiParent row2 = new GuiParent();
        config.add((GuiControl)row2);
        row2.add((GuiControl)new GuiBlueprintMoveButton(this, Facing.WEST));
        row2.add((GuiControl)new GuiBlueprintMoveButton(this, Facing.DOWN));
        row2.add((GuiControl)new GuiBlueprintMoveButton(this, Facing.NORTH));
        upper.add((GuiControl)new GuiAnimationPanel(this.blueprint.tree, this.blueprint.storage, true, null));
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addRight((GuiControl)new GuiButton("test", x -> {
            this.blueprint.storage.resetOverlap();
            BlueprintTest.testModule(this.blueprint, BlueprintTest.OVERLAP_TEST);
        }).setTranslate("gui.blueprint.test.overlap"));
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            for (GuiTreeItem item : this.tree.allItems()) {
                if (!(item instanceof GuiBlueprintMoveItem)) continue;
                GuiBlueprintMoveItem move = (GuiBlueprintMoveItem)item;
                move.structure.applyOffset();
            }
            this.closeThisLayer();
        }).setTranslate("gui.save"));
        this.tree.updateTree();
    }

    public void move(Facing facing) {
        GuiDistanceControl distance = (GuiDistanceControl)this.get("distance");
        GuiStateButton modes = (GuiStateButton)this.get("modes");
        LittleVec direction = new LittleVec(facing);
        direction.scale(distance.getDistance());
        LittleVecGrid vec = new LittleVecGrid(direction, distance.getDistanceGrid());
        for (GuiBlueprintMoveItem item : ((GuiBlueprintMoveMode)((Object)modes.selected())).iterator(this.tree)) {
            item.addOffset(vec);
        }
    }

    public class GuiBlueprintMoveItem
    extends GuiTreeItem {
        public final GuiTreeItemStructure structure;

        public GuiBlueprintMoveItem(GuiTree tree, GuiTreeItemStructure structure) {
            super("item", tree);
            this.structure = structure;
            this.setTitle((Component)Component.literal((String)structure.getTitle()));
        }

        public void addOffset(LittleVecGrid vec) {
            LittleVecGrid offset = this.structure.getOffset();
            if (offset == null) {
                this.structure.setOffset(vec.copy());
            } else {
                offset.add(vec);
            }
        }

        public void addChildren() {
            for (GuiTreeItem item : this.structure.items()) {
                GuiBlueprintMoveItem child = new GuiBlueprintMoveItem(this.tree, (GuiTreeItemStructure)item);
                this.addItem(child);
                child.addChildren();
            }
        }
    }

    public static enum GuiBlueprintMoveMode {
        DEFAULT(false){

            @Override
            public Iterable<GuiBlueprintMoveItem> iterator(GuiTree tree) {
                if (tree.selected() == null) {
                    return Collections.EMPTY_LIST;
                }
                return new SingleIterator((Object)((GuiBlueprintMoveItem)tree.selected()));
            }
        }
        ,
        CHECKBOX(true){

            @Override
            public Iterable<GuiBlueprintMoveItem> iterator(GuiTree tree) {
                return new FunctionIterator(tree.itemsChecked(), x -> (GuiBlueprintMoveItem)((Object)x));
            }
        };

        public final boolean checkboxes;

        private GuiBlueprintMoveMode(boolean checkboxes) {
            this.checkboxes = checkboxes;
        }

        public Component title() {
            return Component.translatable((String)("gui.blueprint.move.mode." + this.name().toLowerCase()));
        }

        public void select(GuiTree tree) {
            tree.setCheckboxes(this.checkboxes, false);
            tree.updateTree();
        }

        public abstract Iterable<GuiBlueprintMoveItem> iterator(GuiTree var1);
    }

    public class GuiBlueprintMoveButton
    extends GuiButton {
        public GuiBlueprintMoveButton(GuiBlueprintMove this$0, Facing facing) {
            super(facing.name, x -> this$0.move(facing));
            this.setTitle(facing.translate());
        }
    }
}

