/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.blueprint;

import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.gui.control.GuiGridConfig;
import team.creative.littletiles.common.gui.tool.GuiConfigureTool;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.placement.setting.PlacementPlayerSetting;

public class GuiBlueprintSecondary
extends GuiConfigureTool {
    public GuiBlueprintSecondary(ContainerSlotView view) {
        super("blueprint_secondary", 160, 240, view);
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
        this.spacing = 4;
        this.registerEventChanged(x -> {
            if (x.control.is("mode")) {
                GuiComboBox modeBox = (GuiComboBox)x.control;
                TextBuilder builder = new TextBuilder();
                if (((PlacementMode)modeBox.selected()).canPlaceStructures()) {
                    builder.text(String.valueOf(ChatFormatting.BOLD)).translate("placement.mode.placestructure").text(String.valueOf(ChatFormatting.WHITE)).newLine();
                }
                builder.translate(((PlacementMode)modeBox.selected()).translatableKey() + ".tooltip");
                ((GuiLabel)this.get("text")).setTitle(builder.build());
                LittleTilesClient.placementMode((PlacementMode)modeBox.selected());
            }
        });
    }

    @Override
    public boolean saveConfiguration(PatchedDataComponentMap data) {
        data.set((DataComponentType)LittleTilesRegistry.COLOR.get(), (Object)((GuiColorPicker)this.get((String)"picker", GuiColorPicker.class)).color.toInt());
        data.set((DataComponentType)LittleTilesRegistry.COLOR_SECONDARY.get(), (Object)((GuiColorPicker)this.get((String)"picker2", GuiColorPicker.class)).color.toInt());
        return true;
    }

    public void create() {
        if (!this.isClient()) {
            return;
        }
        this.add((GuiControl)new GuiLabel("label").setTranslate("gui.blueprint.color.primary"));
        this.add((GuiControl)new GuiColorPicker("picker", new Color(((Integer)this.tool.get().getOrDefault(LittleTilesRegistry.COLOR, (Object)ItemLittleBlueprint.DEFAULT_COLOR)).intValue()), LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        this.add((GuiControl)new GuiLabel("label").setTranslate("gui.blueprint.color.secondary"));
        this.add((GuiControl)new GuiColorPicker("picker2", new Color(((Integer)this.tool.get().getOrDefault(LittleTilesRegistry.COLOR_SECONDARY, (Object)ItemLittleBlueprint.DEFAULT_COLOR_SECONDARY)).intValue()), LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        this.add((GuiControl)new GuiGridConfig("grid", this.getPlayer(), PlacementPlayerSetting.grid(this.getPlayer()), LittleTilesClient::grid));
        GuiComboBox modeBox = new GuiComboBox("mode", PlacementMode.map());
        modeBox.select((Object)PlacementPlayerSetting.placementMode(this.getPlayer()));
        this.add((GuiControl)modeBox);
        this.add((GuiControl)new GuiLabel("text"));
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)modeBox));
    }
}

