/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.blueprint.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.littletiles.common.gui.tool.blueprint.GuiBlueprint;
import team.creative.littletiles.common.gui.tool.blueprint.GuiTreeItemStructure;
import team.creative.littletiles.common.gui.tool.blueprint.test.BlueprintOverlapTest;
import team.creative.littletiles.common.gui.tool.blueprint.test.BlueprintSignalEquationTest;
import team.creative.littletiles.common.gui.tool.blueprint.test.BlueprintTestModule;
import team.creative.littletiles.common.gui.tool.blueprint.test.BlueprintTestResults;

public class BlueprintTest {
    public static final BlueprintOverlapTest OVERLAP_TEST = new BlueprintOverlapTest();
    public static final BlueprintSignalEquationTest SIGNAL_TEST = new BlueprintSignalEquationTest();
    public static final BlueprintTest STANDARD = new BlueprintTest(Arrays.asList(OVERLAP_TEST, SIGNAL_TEST));
    private final List<BlueprintTestModule> modules;

    public static BlueprintTestResults testModule(GuiBlueprint blueprint, BlueprintTestModule module) {
        BlueprintTest.resetBeforeTest(blueprint);
        BlueprintTestResults results = new BlueprintTestResults();
        module.startTest(blueprint, results);
        for (GuiTreeItem child : blueprint.tree.root().items()) {
            BlueprintTest.testStructure(module, (GuiTreeItemStructure)child, results);
        }
        module.endTest(blueprint, results);
        return results;
    }

    protected static void testStructure(BlueprintTestModule module, GuiTreeItemStructure item, BlueprintTestResults results) {
        module.test(item, results);
        for (GuiTreeItem child : item.items()) {
            BlueprintTest.testStructure(module, (GuiTreeItemStructure)child, results);
        }
    }

    public static void resetBeforeTest(GuiBlueprint blueprint) {
        blueprint.storage.resetOverlap();
    }

    public BlueprintTest(List<BlueprintTestModule> modules) {
        this.modules = new ArrayList<BlueprintTestModule>(modules);
    }

    public void addModule(BlueprintTestModule module) {
        this.modules.add(module);
    }

    public BlueprintTestResults test(GuiBlueprint blueprint) {
        BlueprintTest.resetBeforeTest(blueprint);
        BlueprintTestResults results = new BlueprintTestResults();
        for (BlueprintTestModule module : this.modules) {
            module.startTest(blueprint, results);
        }
        for (GuiTreeItem child : blueprint.tree.root().items()) {
            this.testStructure((GuiTreeItemStructure)child, results);
        }
        for (BlueprintTestModule module : this.modules) {
            module.endTest(blueprint, results);
        }
        return results;
    }

    protected void testStructure(GuiTreeItemStructure item, BlueprintTestResults results) {
        for (BlueprintTestModule module : this.modules) {
            module.test(item, results);
        }
        for (GuiTreeItem child : item.items()) {
            this.testStructure((GuiTreeItemStructure)child, results);
        }
    }
}

