/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.blueprint.test;

import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiPanel;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.littletiles.common.gui.tool.blueprint.GuiBlueprint;
import team.creative.littletiles.common.gui.tool.blueprint.test.BlueprintTestError;
import team.creative.littletiles.common.gui.tool.blueprint.test.BlueprintTestResults;

public class GuiBlueprintTest
extends GuiLayer {
    public BlueprintTestResults results;
    public GuiBlueprint blueprint;

    public GuiBlueprintTest() {
        super("gui.blueprint.test", 300, 200);
        this.flow = GuiFlow.STACK_Y;
    }

    public void init(GuiBlueprint blueprint) {
        this.blueprint = blueprint;
        this.results = blueprint.runTest();
        this.clear();
        this.init();
    }

    public void becameTopLayer() {
        if (this.blueprint != null) {
            this.init(this.blueprint);
        }
    }

    public void create() {
        if (this.results == null) {
            return;
        }
        GuiScrollY box = new GuiScrollY();
        this.add((GuiControl)box.setExpandable());
        for (BlueprintTestError error : this.results) {
            GuiPanel content = new GuiPanel((GuiFlow)GuiFlow.STACK_Y);
            box.add((GuiControl)content);
            content.add((GuiControl)new GuiLabel("header").setTitle(error.header()));
            content.add((GuiControl)new GuiLabel("desc").setTitle(error.description()));
            GuiParent bottomLine = new GuiParent((GuiFlow)GuiFlow.STACK_X).setAlign(Align.CENTER).setVAlign(VAlign.CENTER);
            content.add(bottomLine.setExpandableX());
            error.create(this.blueprint, bottomLine, () -> this.init(this.blueprint));
        }
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("refresh", x -> this.init(this.blueprint)).setTranslate("gui.blueprint.test.recheck"));
        bottom.addRight((GuiControl)new GuiButton("okay", x -> this.closeThisLayer()).setTranslate("gui.okay"));
    }
}

