/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.mc.TooltipUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittleShaper;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.client.tool.shaper.LittleToolShaper;
import team.creative.littletiles.client.tool.shaper.ShapeSelection;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.gui.tool.GuiChisel;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.packet.action.ChangedElementPacket;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.PreviewMode;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;

public class ItemLittleChisel
extends Item
implements ILittleShaper,
IItemTooltip {
    public ItemLittleChisel() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    @Override
    public boolean hasShape(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public LittleShape defaultShape() {
        return ShapeRegistry.DRAG_BOX;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        this.getShape(stack).appendInformation(stack, context, tooltip, flag);
        tooltip.add((Component)Component.literal((String)TooltipUtils.printColor((int)LittleElement.getOrDefault((ItemStack)stack).color)));
    }

    @Override
    public void shapeFinished(Level level, Player player, ItemStack stack, ShapeSelection selection, LittleBoxes boxes) {
        if (LittleTilesClient.INTERACTION.start(true)) {
            LittleGroupAbsolute previews = new LittleGroupAbsolute(boxes.pos);
            previews.add(boxes.grid, LittleElement.getOrDefault(stack), boxes);
            LittleTilesClient.ACTION_HANDLER.execute(new LittleActionPlace(LittleActionPlace.PlaceAction.ABSOLUTE, PlacementPreview.absolute(level, LittleTilesClient.ACTION_HANDLER.setting.placementMode(), previews)));
        }
    }

    @Override
    public boolean selectLeftClick(Player player, ItemStack stack) {
        return false;
    }

    @Override
    public PreviewMode previewMode(Player player, ItemStack stack) {
        return LittleTilesClient.ACTION_HANDLER.setting.placementMode().placeInside || LittleTiles.CONFIG.rendering.previewLines ? PreviewMode.LINES : PreviewMode.PREVIEWS;
    }

    @Override
    public boolean previewInside(Player player, ItemStack stack) {
        return LittleTilesClient.ACTION_HANDLER.setting.placementMode().placeInside;
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view, boolean secondary) {
        return new GuiChisel(view);
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{this.getShape(stack).translatable(), Minecraft.getInstance().options.keyPickItem.getTranslatedKeyMessage(), LittleTilesClient.KEY_MARK.getTranslatedKeyMessage(), LittleTilesClient.arrowKeysTooltip(), LittleTilesClient.KEY_CONFIGURE.getTranslatedKeyMessage()};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Iterable<LittleTool> tools(ItemStack stack) {
        return Arrays.asList(new LittleToolShaper(this, stack){

            @Override
            public boolean onMouseWheelClickBlock(Level level, Player player, BlockHitResult result) {
                BlockState state = level.getBlockState(result.getBlockPos());
                if (LittleAction.isBlockValid(state)) {
                    LittleTiles.NETWORK.sendToServer((CreativePacket)new ChangedElementPacket(new LittleElement(state, -1)));
                    return true;
                }
                if (state.getBlock() instanceof BlockTile) {
                    LittleTileContext context = LittleTileContext.selectFocused((BlockGetter)level, result.getBlockPos(), player);
                    if (context.isComplete()) {
                        LittleTiles.NETWORK.sendToServer((CreativePacket)new ChangedElementPacket(context.tile));
                    }
                    return true;
                }
                return false;
            }
        });
    }
}

