/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.api.common.tool.ILittleTransformer;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.client.tool.LittleToolTransformer;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.GuiGlove;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.placement.PlacementPreview;

public class ItemLittleGlove
extends Item
implements ILittleTransformer,
IItemTooltip {
    public ItemLittleGlove() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view, boolean secondary) {
        return new GuiGlove(view);
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{Minecraft.getInstance().options.keyPickItem.getTranslatedKeyMessage(), Minecraft.getInstance().options.keyUse.getTranslatedKeyMessage(), Minecraft.getInstance().options.keyAttack.getTranslatedKeyMessage(), LittleTilesClient.KEY_CONFIGURE.getTranslatedKeyMessage()};
    }

    @Override
    public void boxFinished(Level level, Player player, ItemStack stack, LittleBoxAbsolute box) {
        if (LittleTilesClient.INTERACTION.start(true)) {
            LittleGroupAbsolute previews = new LittleGroupAbsolute(box.pos);
            previews.add(box.grid, LittleElement.getOrDefault(stack), LittleBoxes.of(box));
            LittleTilesClient.ACTION_HANDLER.execute(new LittleActionPlace(LittleActionPlace.PlaceAction.ABSOLUTE, PlacementPreview.absolute(level, LittleTilesClient.ACTION_HANDLER.setting.placementMode(), previews)));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Iterable<LittleTool> tools(ItemStack stack) {
        return Arrays.asList(new LittleToolTransformer(stack));
    }
}

