/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.client.tool.LittleToolWrench;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class ItemLittleWrench
extends Item
implements ILittleTool,
IItemTooltip {
    public ItemLittleWrench() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof BETiles && context.getLevel().isClientSide) {
            LittleTileContext result = LittleTileContext.selectFocused((BlockGetter)context.getLevel(), context.getClickedPos(), context.getPlayer());
            if (context.getPlayer().isCrouching()) {
                if (result.isComplete() && result.parent.isStructure()) {
                    try {
                        LittleTilesGuiRegistry.STRUCTURE_SIGNAL.open(context.getPlayer(), result.parent.getStructure());
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
                } else {
                    LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(context.getLevel(), context.getClickedPos(), context.getPlayer(), BlockPacket.BlockPacketAction.WRENCH));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Iterable<LittleTool> tools(ItemStack stack) {
        return Arrays.asList(new LittleToolWrench(stack));
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{Minecraft.getInstance().options.keyUse.getTranslatedKeyMessage(), Minecraft.getInstance().options.keyUse.getTranslatedKeyMessage()};
    }
}

