/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VectorUtils;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class LittleBoxAbsolute
implements IGridBased {
    public BlockPos pos;
    public LittleGrid grid;
    public LittleBox box;

    public LittleBoxAbsolute(BlockPos pos) {
        this.pos = pos;
        this.grid = LittleGrid.MIN;
        this.box = new LittleBox(0, 0, 0, this.grid.count, this.grid.count, this.grid.count);
    }

    public LittleBoxAbsolute(BlockPos pos, LittleBox box, LittleGrid grid) {
        this.set(pos, box, grid);
    }

    public LittleBoxAbsolute(BlockPos pos, LittleBoxGrid box) {
        this.set(pos, box);
    }

    public void set(BlockPos pos, LittleBox box, LittleGrid grid) {
        this.pos = pos;
        this.box = box;
        this.grid = grid;
    }

    public void set(BlockPos pos, LittleBoxGrid box) {
        this.pos = pos;
        this.box = box.getBox();
        this.grid = box.getGrid();
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public void convertTo(LittleGrid to) {
        this.box.convertTo(this.grid, to);
        this.grid = to;
    }

    @Override
    public int getSmallest() {
        return this.box.getSmallest(this.grid);
    }

    public void include(LittleGrid grid, BlockPos pos, LittleBox box) {
        if (grid != this.grid) {
            if (grid.count > this.grid.count) {
                this.convertTo(grid);
            } else {
                box.convertTo(grid, this.grid);
            }
        }
        BlockPos offset = pos.subtract((Vec3i)this.pos);
        this.box.minX = Math.min(box.minX + grid.toGrid(offset.getX()), this.box.minX);
        this.box.minY = Math.min(box.minY + grid.toGrid(offset.getY()), this.box.minY);
        this.box.minZ = Math.min(box.minZ + grid.toGrid(offset.getZ()), this.box.minZ);
        this.box.maxX = Math.max(box.maxX + grid.toGrid(offset.getX()), this.box.maxX);
        this.box.maxY = Math.max(box.maxY + grid.toGrid(offset.getY()), this.box.maxY);
        this.box.maxZ = Math.max(box.maxZ + grid.toGrid(offset.getZ()), this.box.maxZ);
    }

    public LittleVec getDoubledCenter(BlockPos pos) {
        double x = (double)(this.box.maxX + this.box.minX) / 2.0;
        double y = (double)(this.box.maxY + this.box.minY) / 2.0;
        double z = (double)(this.box.maxZ + this.box.minZ) / 2.0;
        return new LittleVec((int)((x += (double)this.grid.toGrid(this.pos.getX() - pos.getX())) * 2.0), (int)((y += (double)this.grid.toGrid(this.pos.getY() - pos.getY())) * 2.0), (int)((z += (double)this.grid.toGrid(this.pos.getZ() - pos.getZ())) * 2.0));
    }

    public LittleVec getDoubledCenter() {
        double x = (double)(this.box.maxX + this.box.minX) / 2.0;
        double y = (double)(this.box.maxY + this.box.minY) / 2.0;
        double z = (double)(this.box.maxZ + this.box.minZ) / 2.0;
        return new LittleVec((int)(x * 2.0), (int)(y * 2.0), (int)(z * 2.0));
    }

    public LittleVecGrid getSize() {
        return new LittleVecGrid(this.box.getSize(), this.grid);
    }

    public Vec3d getVanillaCenter() {
        Vec3d vec = new Vec3d((Vec3i)this.pos);
        vec.x += this.grid.toVanillaGrid((double)(this.box.maxX + this.box.minX) / 2.0);
        vec.y += this.grid.toVanillaGrid((double)(this.box.maxY + this.box.minY) / 2.0);
        vec.z += this.grid.toVanillaGrid((double)(this.box.maxZ + this.box.minZ) / 2.0);
        return vec;
    }

    public HashMapList<BlockPos, LittleBox> splitted() {
        HashMapList boxes = new HashMapList();
        this.box.split(this.grid, this.pos, LittleVec.ZERO, (HashMapList<BlockPos, LittleBox>)boxes, null);
        return boxes;
    }

    public int getMinPos(Axis axis) {
        switch (axis) {
            case X: {
                return this.pos.getX() + this.grid.toBlockOffset(this.box.minX);
            }
            case Y: {
                return this.pos.getY() + this.grid.toBlockOffset(this.box.minY);
            }
            case Z: {
                return this.pos.getZ() + this.grid.toBlockOffset(this.box.minZ);
            }
        }
        return 0;
    }

    public int getMinGridFrom(Axis axis, BlockPos pos) {
        return this.grid.toGrid(VectorUtils.get((Axis)axis, (Vec3i)this.pos) - VectorUtils.get((Axis)axis, (Vec3i)pos)) + this.box.getMin(axis);
    }

    public BlockPos getMinPos() {
        int x = this.grid.toBlockOffset(this.box.minX);
        int y = this.grid.toBlockOffset(this.box.minY);
        int z = this.grid.toBlockOffset(this.box.minZ);
        if (x != 0 || y != 0 || z != 0) {
            return this.pos.offset(x, y, z);
        }
        return this.pos;
    }

    public int getMaxPos(Axis axis) {
        switch (axis) {
            case X: {
                return this.pos.getX() + this.grid.toBlockOffset(this.box.maxX);
            }
            case Y: {
                return this.pos.getY() + this.grid.toBlockOffset(this.box.maxY);
            }
            case Z: {
                return this.pos.getZ() + this.grid.toBlockOffset(this.box.maxZ);
            }
        }
        return 0;
    }

    public int getMaxGridFrom(Axis axis, BlockPos pos) {
        return this.grid.toGrid(VectorUtils.get((Axis)axis, (Vec3i)this.pos) - VectorUtils.get((Axis)axis, (Vec3i)pos)) + this.box.getMax(axis);
    }

    public BlockPos getMaxPos() {
        int x = this.grid.toBlockOffset(this.box.maxX);
        int y = this.grid.toBlockOffset(this.box.maxY);
        int z = this.grid.toBlockOffset(this.box.maxZ);
        if (x != 0 || y != 0 || z != 0) {
            return this.pos.offset(x, y, z);
        }
        return this.pos;
    }

    public int getDistanceIfEqualFromOneSide(Facing facing, LittleBoxAbsolute box) {
        return this.getDistanceIfEqualFromOneSide(facing, box.box, box.pos, box.grid);
    }

    public int getDistanceIfEqualFromOneSide(Facing facing, LittleBox box, BlockPos pos, LittleGrid grid) {
        this.minGrid(grid);
        if (this.grid.count > grid.count) {
            box = box.copy();
            box.convertTo(grid, this.grid);
            grid = this.grid;
        }
        Axis one = facing.one();
        Axis two = facing.two();
        int diffOne = grid.toGrid(VectorUtils.get((Axis)one, (Vec3i)this.pos) - VectorUtils.get((Axis)one, (Vec3i)pos));
        int diffTwo = grid.toGrid(VectorUtils.get((Axis)two, (Vec3i)this.pos) - VectorUtils.get((Axis)two, (Vec3i)pos));
        if (box.getMin(one) - diffOne == this.box.getMin(one) && box.getMin(two) - diffTwo == this.box.getMin(two)) {
            return facing.positive ? box.getMin(facing.axis) - grid.toGrid(VectorUtils.get((Axis)facing.axis, (Vec3i)this.pos) - VectorUtils.get((Axis)facing.axis, (Vec3i)pos)) - this.box.getMax(facing.axis) : this.box.getMin(facing.axis) - (box.getMax(facing.axis) - grid.toGrid(VectorUtils.get((Axis)facing.axis, (Vec3i)this.pos) - VectorUtils.get((Axis)facing.axis, (Vec3i)pos)));
        }
        return -1;
    }

    public LittleBoxAbsolute createBoxFromFace(Facing facing, int size) {
        LittleBoxAbsolute newBox = new LittleBoxAbsolute(this.pos, this.box.copy(), this.grid);
        if (facing.positive) {
            int max = this.box.getMax(facing.axis);
            newBox.box.setMin(facing.axis, max);
            newBox.box.setMax(facing.axis, max + size);
        } else {
            int min = this.box.getMin(facing.axis);
            newBox.box.setMin(facing.axis, min - size);
            newBox.box.setMax(facing.axis, min);
        }
        return newBox;
    }

    public LittleBoxAbsolute copy() {
        return new LittleBoxAbsolute(this.pos, this.box.copy(), this.grid);
    }

    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox() {
        return this.box.getRenderingBox(this.grid);
    }
}

