/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.vec;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.security.InvalidParameterException;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class LittleVecAbsolute
implements IGridBased {
    protected BlockPos pos;
    protected LittleVecGrid gridVec;

    public LittleVecAbsolute(String name, CompoundTag nbt) {
        int[] array = nbt.getIntArray(name);
        if (array.length != 7) {
            throw new InvalidParameterException("No valid coords given " + String.valueOf(nbt));
        }
        this.pos = new BlockPos(array[0], array[1], array[2]);
        this.gridVec = new LittleVecGrid(new LittleVec(array[4], array[5], array[6]), LittleGrid.get(array[3]));
    }

    public LittleVecAbsolute(HitResult result, LittleGrid grid) {
        long x = grid.toGridAccurate(result.getLocation().x);
        long y = grid.toGridAccurate(result.getLocation().y);
        long z = grid.toGridAccurate(result.getLocation().z);
        this.pos = new BlockPos((int)Math.floor(grid.toVanillaGrid(x)), (int)Math.floor(grid.toVanillaGrid(y)), (int)Math.floor(grid.toVanillaGrid(z)));
        this.gridVec = new LittleVecGrid(new LittleVec((int)(x - grid.toGridAccurate(this.pos.getX())), (int)(y - grid.toGridAccurate(this.pos.getY())), (int)(z - grid.toGridAccurate(this.pos.getZ()))), grid);
    }

    public LittleVecAbsolute(BlockPos pos, LittleGrid context) {
        this(pos, new LittleVecGrid(new LittleVec(0, 0, 0), context));
    }

    public LittleVecAbsolute(BlockPos pos, LittleGrid context, LittleVec vec) {
        this(pos, new LittleVecGrid(vec, context));
    }

    public LittleVecAbsolute(BlockPos pos, LittleVecGrid gridVec) {
        this.pos = pos;
        this.gridVec = gridVec;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public int getSmallest() {
        return this.gridVec.getSmallest();
    }

    @Override
    public LittleGrid getGrid() {
        return this.gridVec.getGrid();
    }

    @Override
    public void convertTo(LittleGrid to) {
        this.gridVec.convertTo(to);
    }

    public LittleVec getRelative(BlockPos pos) {
        LittleVec newVec = new LittleVec(this.getGrid(), (Vec3i)this.pos.subtract((Vec3i)pos));
        newVec.add(this.gridVec.vec);
        return newVec;
    }

    public LittleVecGrid getRelative(LittleVecAbsolute pos) {
        this.forceSameGrid((IGridBased)pos);
        LittleVecGrid newVec = new LittleVecGrid(new LittleVec(this.getGrid(), (Vec3i)this.pos.subtract((Vec3i)pos.pos)), this.getGrid());
        newVec.vec.add(this.gridVec.vec);
        newVec.vec.sub(pos.gridVec.vec);
        pos.convertToSmallest();
        this.convertToSmallest();
        return newVec;
    }

    @Override
    public void convertToSmallest() {
        this.removeInternalBlockOffset();
        IGridBased.super.convertToSmallest();
    }

    public void add(LittleVecAbsolute pos) {
        this.pos = this.pos.offset((Vec3i)pos.pos);
        this.sameGrid((IGridBased)pos, () -> this.gridVec.vec.add(pos.gridVec.vec));
    }

    public void sub(LittleVecAbsolute pos) {
        this.pos = this.pos.subtract((Vec3i)pos.pos);
        this.sameGrid((IGridBased)pos, () -> this.gridVec.vec.sub(pos.gridVec.vec));
    }

    public void add(Vec3i vec) {
        this.pos = this.pos.offset(vec);
    }

    public void sub(Vec3i vec) {
        this.pos = this.pos.subtract(vec);
    }

    public void add(LittleVecGrid vec) {
        this.gridVec.add(vec);
    }

    public void sub(LittleVecGrid vec) {
        this.gridVec.sub(vec);
    }

    public void removeInternalBlockOffset() {
        int amount;
        LittleGrid context = this.getGrid();
        if (this.gridVec.vec.x >= context.count) {
            amount = this.gridVec.vec.x / context.count;
            this.gridVec.vec.x -= amount * context.count;
            this.pos = this.pos.offset(amount, 0, 0);
        }
        if (this.gridVec.vec.y >= context.count) {
            amount = this.gridVec.vec.y / context.count;
            this.gridVec.vec.y -= amount * context.count;
            this.pos = this.pos.offset(0, amount, 0);
        }
        if (this.gridVec.vec.z >= context.count) {
            amount = this.gridVec.vec.z / context.count;
            this.gridVec.vec.z -= amount * context.count;
            this.pos = this.pos.offset(0, 0, amount);
        }
        if (this.gridVec.vec.x < 0) {
            amount = (int)Math.ceil(Math.abs((double)this.gridVec.vec.x / (double)context.count));
            this.gridVec.vec.x += amount * context.count;
            this.pos = this.pos.offset(-amount, 0, 0);
        }
        if (this.gridVec.vec.y < 0) {
            amount = (int)Math.ceil(Math.abs((double)this.gridVec.vec.y / (double)context.count));
            this.gridVec.vec.y += amount * context.count;
            this.pos = this.pos.offset(0, -amount, 0);
        }
        if (this.gridVec.vec.z < 0) {
            amount = (int)Math.ceil(Math.abs((double)this.gridVec.vec.z / (double)context.count));
            this.gridVec.vec.z += amount * context.count;
            this.pos = this.pos.offset(0, 0, -amount);
        }
    }

    public LittleVecAbsolute copy() {
        return new LittleVecAbsolute(this.pos, this.gridVec.copy());
    }

    public double getVanillaGrid(Axis axis) {
        switch (axis) {
            case X: {
                return this.getPosX();
            }
            case Y: {
                return this.getPosY();
            }
            case Z: {
                return this.getPosZ();
            }
        }
        return 0.0;
    }

    public double getPosX() {
        return (double)this.pos.getX() + this.gridVec.getPosX();
    }

    public double getPosY() {
        return (double)this.pos.getY() + this.gridVec.getPosY();
    }

    public double getPosZ() {
        return (double)this.pos.getZ() + this.gridVec.getPosZ();
    }

    public Vec3d getVec3d() {
        return new Vec3d(this.getPosX(), this.getPosY(), this.getPosZ());
    }

    public void writeToNBT(String name, CompoundTag nbt) {
        nbt.putIntArray(name, new int[]{this.pos.getX(), this.pos.getY(), this.pos.getZ(), this.gridVec.grid.count, this.gridVec.vec.x, this.gridVec.vec.y, this.gridVec.vec.z});
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public LittleVecGrid getVecGrid() {
        return this.gridVec;
    }

    public LittleVec getVec() {
        return this.gridVec.getVec();
    }

    public void setVecContext(LittleVecGrid vec) {
        this.gridVec = vec;
    }

    @Deprecated
    public void overwriteGrid(LittleGrid grid) {
        this.gridVec.overwriteGrid(grid);
    }

    public ABB getBB() {
        LittleGrid grid = this.getGrid();
        double x = this.getPosX();
        double y = this.getPosY();
        double z = this.getPosZ();
        return new ABB(x, y, z, x + grid.pixelLength, y + grid.pixelLength, z + grid.pixelLength);
    }

    public AABB getBox() {
        LittleGrid grid = this.getGrid();
        double x = this.getPosX();
        double y = this.getPosY();
        double z = this.getPosZ();
        return new AABB(x, y, z, x + grid.pixelLength, y + grid.pixelLength, z + grid.pixelLength);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack pose, boolean selected) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        ABB box = this.getBB();
        box.inflate(0.002);
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        RenderSystem.lineWidth((float)4.0f);
        box.renderLines(pose, (VertexConsumer)bufferbuilder, 0.0f, 0.0f, 0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableDepthTest();
        if (selected) {
            bufferbuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
            RenderSystem.lineWidth((float)1.0f);
            box.renderLines(pose, (VertexConsumer)bufferbuilder, 1.0f, 0.3f, 0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    public boolean equals(Object paramObject) {
        if (paramObject instanceof LittleVecAbsolute) {
            LittleVecAbsolute pos = (LittleVecAbsolute)paramObject;
            LittleGrid newContext = LittleGrid.max(this.getGrid(), pos.getGrid());
            int multiplier = newContext.count / this.getGrid().count;
            long thisX = this.pos.getX() * newContext.count + this.gridVec.vec.x * multiplier;
            long thisY = this.pos.getY() * newContext.count + this.gridVec.vec.y * multiplier;
            long thisZ = this.pos.getZ() * newContext.count + this.gridVec.vec.z * multiplier;
            multiplier = newContext.count / pos.getGrid().count;
            long otherX = pos.pos.getX() * newContext.count + pos.gridVec.vec.x * multiplier;
            long otherY = pos.pos.getY() * newContext.count + pos.gridVec.vec.y * multiplier;
            long otherZ = pos.pos.getZ() * newContext.count + pos.gridVec.vec.z * multiplier;
            return thisX == otherX && thisY == otherY && thisZ == otherZ;
        }
        return super.equals(paramObject);
    }

    public String toString() {
        return "[" + this.pos.getX() + "," + this.pos.getY() + "," + this.pos.getZ() + ",grid:" + this.gridVec.grid.count + "," + this.gridVec.vec.x + "," + this.gridVec.vec.y + "," + this.gridVec.vec.z + "]";
    }
}

