/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet.structure;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.text.ParseException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.common.action.exception.LittleActionException;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.output.SignalExternalOutputHandler;

public class StructureOutputConfigurationChanged
extends CreativePacket {
    public CompoundTag nbt;
    public StructureLocation location;

    public StructureOutputConfigurationChanged(StructureLocation location, CompoundTag nbt) {
        this.location = location;
        this.nbt = nbt;
    }

    public StructureOutputConfigurationChanged() {
    }

    public void executeClient(Player player) {
    }

    public void executeServer(ServerPlayer player) {
        try {
            LittleStructure structure = this.location.find((LevelAccessor)player.level());
            ListTag list = this.nbt.getList("internal", 10);
            for (int i = 0; i < list.size(); ++i) {
                structure.getOutput(i).loadConfiguration(list.getCompound(i));
            }
            CompoundTag external = this.nbt.getCompound("external");
            Int2ObjectArrayMap map = new Int2ObjectArrayMap();
            for (String key : external.getAllKeys()) {
                try {
                    map.put(Integer.parseInt(key), (Object)new SignalExternalOutputHandler(structure, external.getCompound(key)));
                }
                catch (NumberFormatException | ParseException exception) {}
            }
            structure.setExternalOutputs((Int2ObjectMap<SignalExternalOutputHandler>)map);
            structure.updateStructure();
            structure.notifyChange();
        }
        catch (LittleActionException littleActionException) {
            // empty catch block
        }
    }
}

