/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.selection;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.exception.AreaTooLarge;
import team.creative.littletiles.common.action.exception.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.config.LittlePermissionBuild;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.item.component.SelectionComponent;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import team.creative.littletiles.common.placement.selection.SelectionMode;
import team.creative.littletiles.common.placement.selection.SelectionParameters;
import team.creative.littletiles.common.placement.selection.SelectionResult;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class AreaSelectionMode
extends SelectionMode {
    @Override
    public SelectionResult scan(Level level, SelectionComponent component) {
        CompoundTag nbt = component.getConfig();
        BlockPos pos = null;
        if (nbt.contains("pos1")) {
            int[] array = nbt.getIntArray("pos1");
            pos = new BlockPos(array[0], array[1], array[2]);
        }
        BlockPos pos2 = null;
        if (nbt.contains("pos2")) {
            int[] array = nbt.getIntArray("pos2");
            pos2 = new BlockPos(array[0], array[1], array[2]);
        }
        if (pos == null && pos2 == null) {
            return null;
        }
        if (pos == null) {
            pos = pos2;
        } else if (pos2 == null) {
            pos2 = pos;
        }
        SelectionResult result = new SelectionResult(level);
        result.addBlocks(pos, pos2);
        return result;
    }

    @Override
    public SelectionComponent leftClick(Player player, SelectionComponent component, BlockPos pos) {
        CompoundTag nbt = component.getConfig();
        nbt.putIntArray("pos1", new int[]{pos.getX(), pos.getY(), pos.getZ()});
        if (!player.level().isClientSide) {
            player.sendSystemMessage((Component)Component.translatable((String)"selection.mode.area.pos.first", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}));
        }
        return component.withConfig(nbt);
    }

    @Override
    public SelectionComponent rightClick(Player player, SelectionComponent component, BlockPos pos) {
        CompoundTag nbt = component.getConfig();
        nbt.putIntArray("pos2", new int[]{pos.getX(), pos.getY(), pos.getZ()});
        if (!player.level().isClientSide) {
            player.sendSystemMessage((Component)Component.translatable((String)"selection.mode.area.pos.second", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}));
        }
        return component.withConfig(nbt);
    }

    @Override
    public LittleGroup select(SelectionParameters selection, SelectionComponent component) throws LittleActionException {
        CompoundTag nbt = component.getConfig();
        BlockPos pos = null;
        if (nbt.contains("pos1")) {
            int[] array = nbt.getIntArray("pos1");
            pos = new BlockPos(array[0], array[1], array[2]);
        }
        BlockPos pos2 = null;
        if (nbt.contains("pos2")) {
            int[] array = nbt.getIntArray("pos2");
            pos2 = new BlockPos(array[0], array[1], array[2]);
        }
        if (pos == null && pos2 == null) {
            return null;
        }
        if (pos == null) {
            pos = pos2;
        } else if (pos2 == null) {
            pos2 = pos;
        }
        int minX = Math.min(pos.getX(), pos2.getX());
        int minY = Math.min(pos.getY(), pos2.getY());
        int minZ = Math.min(pos.getZ(), pos2.getZ());
        int maxX = Math.max(pos.getX(), pos2.getX());
        int maxY = Math.max(pos.getY(), pos2.getY());
        int maxZ = Math.max(pos.getZ(), pos2.getZ());
        LittlePermissionBuild config = (LittlePermissionBuild)LittleTiles.CONFIG.build.get(selection.player());
        if (config.blueprintSizeLimit.isEnabled() && (maxX - minX) * (maxY - minY) * (maxZ - minZ) > (Integer)config.blueprintSizeLimit.value) {
            throw new AreaTooLarge(config);
        }
        AreaSelectionSearch search = new AreaSelectionSearch(selection);
        search.scanLevel((LevelAccessor)selection.level(), minX, minY, minZ, maxX, maxY, maxZ);
        AABB bb = new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
        for (LittleEntity animation : ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(selection.level())).find(bb)) {
            search.scanLevel((LevelAccessor)animation.getSubLevel(), minX, minY, minZ, maxX, maxY, maxZ);
        }
        return search.build();
    }

    public static class AreaSelectionSearch {
        public final SelectionParameters selection;
        private final List<LittleStructure> structures;
        private final List<LittleGroup> children = new ArrayList<LittleGroup>();
        private final LittleGroup previews = new LittleGroup();
        private final BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();

        public AreaSelectionSearch(SelectionParameters selection) throws AreaTooLarge {
            this.selection = selection;
            this.structures = selection.rememberStructure() ? new ArrayList() : null;
        }

        public void scanLevel(LevelAccessor level, ABB bb) throws LittleActionException {
            this.scanLevel(level, Mth.floor((double)bb.minX), Mth.floor((double)bb.minY), Mth.floor((double)bb.minZ), Mth.ceil((double)bb.maxX), Mth.ceil((double)bb.maxY), Mth.ceil((double)bb.maxZ));
        }

        public void scanLevel(LevelAccessor level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) throws LittleActionException {
            BlockPos center = new BlockPos(minX, minY, minZ);
            for (int posX = minX; posX <= maxX; ++posX) {
                for (int posY = minY; posY <= maxY; ++posY) {
                    for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                        BlockState state;
                        this.temp.set(posX, posY, posZ);
                        if (this.selection.includeBE()) {
                            LittleGroup specialPreviews;
                            BlockEntity blockEntity = level.getBlockEntity((BlockPos)this.temp);
                            if (this.selection.includeLT() && blockEntity instanceof BETiles) {
                                BETiles be = (BETiles)blockEntity;
                                for (IParentCollection parent : be.groups()) {
                                    if (this.selection.rememberStructure() && parent.isStructure()) {
                                        try {
                                            LittleStructure structure = parent.getStructure();
                                            while (structure.getParent() != null) {
                                                structure = structure.getParent().getStructure();
                                            }
                                            structure.checkConnections();
                                            if (this.structures.contains(structure)) continue;
                                            this.children.add(structure.getPreviews(center));
                                            this.structures.add(structure);
                                        }
                                        catch (CorruptedConnectionException | NotYetConnectedException e) {}
                                        continue;
                                    }
                                    for (LittleTile tile : parent) {
                                        tile = tile.copy();
                                        tile.move(new LittleVec(parent.getGrid().toGrid(posX - minX), parent.getGrid().toGrid(posY - minY), parent.getGrid().toGrid(posZ - minZ)));
                                        this.previews.add(parent.getGrid(), (LittleElement)tile, tile);
                                    }
                                }
                            }
                            if (this.selection.includeCB() && (specialPreviews = ChiselsAndBitsManager.getGroup(blockEntity)) != null) {
                                specialPreviews.move(new LittleVecGrid(new LittleVec(this.previews.getGrid().toGrid(posX - minX), this.previews.getGrid().toGrid(posY - minY), this.previews.getGrid().toGrid(posZ - minZ)), this.previews.getGrid()));
                                this.previews.add(specialPreviews);
                                continue;
                            }
                        }
                        if (!this.selection.includeVanilla() || !LittleAction.isBlockValid(state = level.getBlockState((BlockPos)this.temp))) continue;
                        LittleBox box = this.previews.getGrid().box();
                        box.add(new LittleVec((posX - minX) * this.previews.getGrid().count, (posY - minY) * this.previews.getGrid().count, (posZ - minZ) * this.previews.getGrid().count));
                        this.previews.add(this.previews.getGrid(), new LittleElement(state, -1), box);
                    }
                }
            }
        }

        public LittleGroup build() {
            if (this.children.isEmpty()) {
                return this.previews;
            }
            ArrayList<LittleGroup> newChildren = new ArrayList<LittleGroup>();
            for (LittleGroup child : this.previews.children.children()) {
                newChildren.add(child);
            }
            newChildren.addAll(this.children);
            return new LittleGroup(this.previews, newChildren);
        }
    }
}

