/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.filter.premade.BlockFilters;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.littletiles.LittleTilesRegistry;

public class BlankOMaticRecipeRegistry {
    public static int bleachTotalVolume = 1000;
    private static List<BleachRecipe> recipes = new ArrayList<BleachRecipe>();
    private static List<BleachVolume> bleacher = new ArrayList<BleachVolume>();

    public static void registerBleachRecipe(BleachRecipe recipe) {
        recipes.add(recipe);
    }

    public static void registerBleacher(CreativeIngredient stack, int volume) {
        bleacher.add(new BleachVolume(stack, volume));
    }

    public static List<BleachRecipe> getRecipe(ItemStack stack) {
        Block block = Block.byItem((Item)stack.getItem());
        ArrayList<BleachRecipe> results = new ArrayList<BleachRecipe>();
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).is(block)) continue;
            results.add(recipes.get(i));
        }
        return results;
    }

    public static int getVolume(ItemStack stack) {
        for (int i = 0; i < bleacher.size(); ++i) {
            if (!BlankOMaticRecipeRegistry.bleacher.get((int)i).stack.is(stack)) continue;
            return BlankOMaticRecipeRegistry.bleacher.get((int)i).volume;
        }
        return 0;
    }

    static {
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientItem(Items.BONE_MEAL), 4);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientItem(Items.WHITE_DYE), 4);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientItem(Items.LIGHT_GRAY_DYE), 2);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientItem(Items.GRAY_DYE), 1);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientBlock(Blocks.WHITE_WOOL), 8);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientBlock(Blocks.LIGHT_GRAY_WOOL), 4);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientBlock(Blocks.GRAY_WOOL), 2);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientItem(Items.AZURE_BLUET), 4);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientItem(Items.OXEYE_DAISY), 4);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientItem(Items.WHITE_TULIP), 4);
        BlankOMaticRecipeRegistry.registerBleacher((CreativeIngredient)new CreativeIngredientItem(Items.SUGAR), 1);
        BlankOMaticRecipeRegistry.registerBleachRecipe(new BleachRecipe((Filter<Block>)BlockFilters.block((Block)Blocks.COBBLESTONE), 1, (Block)LittleTilesRegistry.GRAINY.value(), (Block)LittleTilesRegistry.GRAINY_BIG.value()));
        BlankOMaticRecipeRegistry.registerBleachRecipe(new BleachRecipe((Filter<Block>)BlockFilters.block((Block)Blocks.COBBLESTONE), 2, (Block)LittleTilesRegistry.GRAINY_LOW.value()));
        BlankOMaticRecipeRegistry.registerBleachRecipe(new BleachRecipe((Filter<Block>)BlockFilters.block((Block)Blocks.STONE), 1, (Block)LittleTilesRegistry.GRAVEL.value(), (Block)LittleTilesRegistry.SAND.value(), (Block)LittleTilesRegistry.STONE.value(), (Block)LittleTilesRegistry.CLAY.value()));
        BlankOMaticRecipeRegistry.registerBleachRecipe(new BleachRecipe((Filter<Block>)BlockFilters.block((Block)Blocks.STONE), 2, (Block)LittleTilesRegistry.CORK.value()));
        Filter filter = BlockFilters.blocks((Block[])new Block[]{Blocks.STONE_BRICKS, Blocks.BRICKS});
        BlankOMaticRecipeRegistry.registerBleachRecipe(new BleachRecipe((Filter<Block>)filter, 1, (Block)LittleTilesRegistry.BRICK.value(), (Block)LittleTilesRegistry.BRICK_BIG.value(), (Block)LittleTilesRegistry.BROKEN_BRICK_BIG.value(), (Block)LittleTilesRegistry.CHISELED.value(), (Block)LittleTilesRegistry.STRIPS.value()));
        BlankOMaticRecipeRegistry.registerBleachRecipe(new BleachRecipe((Filter<Block>)filter, 2, (Block)LittleTilesRegistry.BORDERED.value(), (Block)LittleTilesRegistry.FLOOR.value()));
        BlankOMaticRecipeRegistry.registerBleachRecipe(new BleachRecipe((Filter<Block>)BlockFilters.tag((TagKey)BlockTags.BASE_STONE_OVERWORLD), 4, (Block)LittleTilesRegistry.CLEAN.value()));
    }

    public static class BleachVolume {
        public CreativeIngredient stack;
        public int volume;

        public BleachVolume(CreativeIngredient stack, int volume) {
            this.stack = stack;
            this.volume = volume;
        }
    }

    public static class BleachRecipe {
        public final Filter<Block> filter;
        public final Block[] results;
        public final int needed;

        public BleachRecipe(Filter<Block> filter, int needed, Block ... results) {
            this.filter = filter;
            this.needed = needed;
            this.results = results;
        }

        public boolean is(Block block) {
            if (this.filter.is((Object)block)) {
                return true;
            }
            for (int i = 0; i < this.results.length; ++i) {
                if (this.results[i] != block) continue;
                return true;
            }
            return false;
        }

        public boolean isResult(ItemStack stack) {
            Block other = Block.byItem((Item)stack.getItem());
            for (int i = 0; i < this.results.length; ++i) {
                if (this.results[i] != other) continue;
                return true;
            }
            return false;
        }
    }
}

