/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.registry.gui;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.gui.control.GuiDirectionIndicator;
import team.creative.littletiles.common.gui.control.animation.GuiIsoAnimationPanel;
import team.creative.littletiles.common.gui.control.animation.GuiIsoAnimationViewer;
import team.creative.littletiles.common.gui.tool.blueprint.GuiTreeItemStructure;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiControl;
import team.creative.littletiles.common.structure.type.bed.LittleBed;

public class LittleBedGui
extends LittleStructureGuiControl {
    public LittleBedGui(LittleStructureGui gui, GuiTreeItemStructure item) {
        super(gui, item);
        this.registerEventChanged(x -> {
            if (x instanceof GuiIsoAnimationViewer.GuiAnimationViewChangedEvent || x.control.is("direction")) {
                GuiIsoAnimationViewer viewer = (GuiIsoAnimationViewer)this.get("viewer");
                GuiComboBox direction = (GuiComboBox)this.get("direction");
                Facing facing = (Facing)direction.selected();
                if (viewer.getXFacing().axis == facing.axis) {
                    facing = viewer.getXFacing().positive == facing.positive ? Facing.EAST : Facing.WEST;
                } else if (viewer.getYFacing().axis == facing.axis) {
                    facing = viewer.getYFacing().positive == facing.positive ? Facing.UP : Facing.DOWN;
                } else if (viewer.getZFacing().axis == facing.axis) {
                    facing = viewer.getZFacing().positive == facing.positive ? Facing.SOUTH : Facing.NORTH;
                }
                ((GuiDirectionIndicator)this.get("relativeDirection", GuiDirectionIndicator.class)).setFacing(facing);
            }
        });
    }

    @Override
    public void create(@Nullable LittleStructure structure) {
        GuiParent right = new GuiParent();
        this.add((GuiControl)right);
        right.add((GuiControl)new GuiIsoAnimationPanel(this.item, new LittleBox(this.item.group.getMinVec()), this.item.group.getGrid(), false).setVisibleAxis(false).setViewerDim(200, 200));
        GuiParent left = new GuiParent();
        this.add((GuiControl)left);
        LittleVec size = this.item.group.getSize();
        Facing facing = Facing.EAST;
        if (size.x < size.z) {
            facing = Facing.SOUTH;
        }
        if (structure instanceof LittleBed) {
            facing = ((LittleBed)structure).direction;
        }
        GuiComboBox button = new GuiComboBox("direction", (IComponentMap)new TextMapBuilder().addComponent((Object[])Facing.HORIZONTA_VALUES, x -> Component.literal((String)x.name)));
        button.select((Object)facing);
        left.add((GuiControl)button);
        GuiDirectionIndicator indicator = new GuiDirectionIndicator("relativeDirection", Facing.UP);
        left.add((GuiControl)indicator);
        this.raiseEvent((GuiEvent)new GuiIsoAnimationViewer.GuiAnimationViewChangedEvent((GuiIsoAnimationViewer)this.get("viewer")));
    }

    @Override
    public LittleStructure save(LittleStructure bed) {
        ((LittleBed)bed).direction = (Facing)((GuiComboBox)this.get("direction")).selected();
        return bed;
    }
}

