/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.registry.gui;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.control.parent.GuiTabs;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.control.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannelDouble;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.control.GuiGridConfig;
import team.creative.littletiles.common.gui.control.GuiPhysicalStateControl;
import team.creative.littletiles.common.gui.control.animation.GuiAnimationTimelinePanel;
import team.creative.littletiles.common.gui.control.animation.GuiIsoAnimationPanel;
import team.creative.littletiles.common.gui.control.animation.GuiIsoAnimationViewer;
import team.creative.littletiles.common.gui.tool.blueprint.GuiBlueprintAnimationHandler;
import team.creative.littletiles.common.gui.tool.blueprint.GuiTreeItemStructure;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.PhysicalPart;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.animation.curve.ValueCurveInterpolation;
import team.creative.littletiles.common.structure.animation.curve.ValueInterpolation;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiControl;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.type.animation.LittleAdvancedDoor;

@OnlyIn(value=Dist.CLIENT)
public class LittleDoorAdvancedGui
extends LittleStructureGuiControl {
    public GuiTimelineConfig same;
    public GuiTimelineConfig different;

    public LittleDoorAdvancedGui(LittleStructureGui gui, GuiTreeItemStructure item) {
        super(gui, item);
    }

    @Override
    public void create(LittleStructure structure) {
        AnimationTimeline closing;
        AnimationTimeline opening;
        int duration;
        boolean sameTransition;
        boolean playPlaceSounds;
        boolean noClip;
        boolean rightClick;
        boolean stayAnimated;
        ValueInterpolation inter;
        boolean even;
        LittleBox box;
        LittleGrid grid;
        PhysicalState closed = new PhysicalState();
        PhysicalState opened = new PhysicalState();
        if (structure instanceof LittleAdvancedDoor) {
            LittleAdvancedDoor door = (LittleAdvancedDoor)structure;
            grid = door.center.getGrid();
            box = door.center.getBox();
            even = door.center.isEven();
            inter = door.interpolation;
            stayAnimated = door.stayAnimated;
            rightClick = door.rightClick;
            noClip = door.noClip;
            playPlaceSounds = door.playPlaceSounds;
            sameTransition = !door.differentTransition;
            duration = Math.max(1, door.duration);
            closed.set((PhysicalState)door.getState("closed"));
            opened.set((PhysicalState)door.getState("opened"));
            opening = door.getTransition("opening");
            if (opening == null) {
                opening = new AnimationTimeline(duration);
            }
            closing = door.getTransition("closing");
            if (sameTransition || closing == null) {
                closing = opening.copy();
                closing.reverse(this.item);
            }
        } else {
            grid = this.item.group.getGrid();
            box = new LittleBox(this.item.group.getMinVec());
            even = false;
            inter = ValueInterpolation.HERMITE;
            stayAnimated = false;
            rightClick = true;
            noClip = false;
            playPlaceSounds = true;
            sameTransition = true;
            duration = 10;
            opening = new AnimationTimeline(duration);
            closing = new AnimationTimeline(duration);
        }
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
        GuiParent upper = new GuiParent();
        this.add((GuiControl)upper);
        upper.add((GuiControl)new GuiIsoAnimationPanel(this.item, box, grid, even).setViewerDim(100, 100).setVisibleAxis(true));
        GuiParent settings = new GuiParent((GuiFlow)GuiFlow.FIT_X).setVAlign(VAlign.CENTER);
        settings.spacing = 5;
        upper.add((GuiControl)settings);
        settings.add((GuiControl)new GuiLabeledControl((Component)Component.translatable((String)"gui.interpolation").append(":"), (GuiControl)new GuiComboBox("inter", (Object)inter, (IComponentMap)new TextMapBuilder().addComponent((Object[])ValueInterpolation.values(), x -> x.translate()))));
        settings.add(new GuiCheckBox("stayAnimated", stayAnimated).setTranslate("gui.stay_animated").setTooltip("gui.door.stay_animated.tooltip"));
        settings.add(new GuiCheckBox("rightClick", rightClick).setTranslate("gui.rightclick").setTooltip("gui.door.rightclick.tooltip"));
        settings.add(new GuiCheckBox("noClip", noClip).setTranslate("gui.no_clip").setTooltip("gui.door.no_clip.tooltip"));
        settings.add(new GuiCheckBox("playPlaceSounds", playPlaceSounds).setTranslate("gui.door.play_place_sound").setTooltip("gui.door.play_place_sound.tooltip"));
        settings.add((GuiControl)new GuiLabeledControl((Component)Component.translatable((String)"gui.duration").append(":"), (GuiControl)new GuiTextfield("duration", "" + duration).setNumbersOnly()));
        GuiIsoAnimationViewer viewer = (GuiIsoAnimationViewer)upper.get("viewer");
        settings.add((GuiControl)new GuiCheckBox("even", viewer.isEven()).setTranslate("gui.door.axis.even"));
        settings.add((GuiControl)new GuiGridConfig("grid", this.getPlayer(), viewer.getGrid(), x -> {
            LittleBox viewerBox = viewer.getBox();
            viewerBox.convertTo(viewer.getGrid(), (LittleGrid)x);
            viewerBox.maxX = viewer.isEven() ? viewerBox.minX + 2 : viewerBox.minX + 1;
            viewerBox.maxY = viewer.isEven() ? viewerBox.minY + 2 : viewerBox.minY + 1;
            viewerBox.maxZ = viewer.isEven() ? viewerBox.minZ + 2 : viewerBox.minZ + 1;
            viewer.setAxis(viewerBox, (LittleGrid)x);
        }));
        settings.registerEventChanged(x -> {
            if (x.control.is("even")) {
                ((GuiIsoAnimationViewer)this.get("viewer", GuiIsoAnimationViewer.class)).setEven(((GuiCheckBox)x.control).value);
            }
            if (x.control.is("inter")) {
                this.updateTimeline();
            }
        });
        GuiTabs tabs = new GuiTabs("tabs");
        this.add(tabs.setExpandableX());
        this.same = new GuiTimelineConfigSame(this.item, this.item.blueprint.animation, closed, opened, duration, opening);
        tabs.createTab((Component)Component.translatable((String)"gui.door.same_transition")).add((GuiControl)this.same);
        this.different = new GuiTimelineConfigDifferent(this.item, this.item.blueprint.animation, closed, opened, duration, opening, closing);
        tabs.createTab((Component)Component.translatable((String)"gui.door.different_transition")).add((GuiControl)this.different);
        tabs.select(sameTransition ? 0 : 1);
        this.registerEvent(GuiIsoAnimationViewer.GuiAnimationAxisChangedEvent.class, x -> this.item.setNewCenter(new StructureAbsolute(new BlockPos(0, 0, 0), viewer.getBox().copy(), viewer.getGrid())));
        this.raiseEvent((GuiEvent)new GuiIsoAnimationViewer.GuiAnimationAxisChangedEvent(viewer));
        tabs.registerEventChanged(x -> {
            if (x.control instanceof GuiTimeline || x.control instanceof GuiTabs || x.control instanceof GuiPhysicalStateControl) {
                this.updateTimeline();
            }
        });
        settings.registerEventChanged(x -> {
            GuiTextfield text;
            GuiControl patt0$temp = x.control;
            if (patt0$temp instanceof GuiTextfield && (text = (GuiTextfield)patt0$temp).is("duration")) {
                int newDuration = text.parseInteger();
                this.same.durationChanged(newDuration);
                this.different.durationChanged(newDuration);
            }
        });
        this.updateTimeline();
    }

    public void updateTimeline() {
        GuiTimelineConfig config = ((GuiTabs)this.get("tabs", GuiTabs.class)).index() != 0 ? this.different : this.same;
        GuiComboBox inter = (GuiComboBox)this.get("inter");
        GuiTextfield durationT = (GuiTextfield)this.get("duration");
        int duration = durationT.parseInteger();
        PhysicalState closed = config.closedState();
        PhysicalState opened = config.openedState();
        boolean opening = config.openingAnimation();
        AnimationTimeline timeline = config.generateTimeline(duration, (ValueInterpolation)((Object)inter.selected()), opening);
        if (opening) {
            timeline.start(closed, opened, ((ValueInterpolation)((Object)inter.selected()))::create1d);
        } else {
            timeline.start(opened, closed, ((ValueInterpolation)((Object)inter.selected()))::create1d);
        }
        this.item.blueprint.animation.setTimeline(this.item, timeline);
    }

    @Override
    public LittleStructure save(LittleStructure structure) {
        LittleAdvancedDoor door = (LittleAdvancedDoor)structure;
        GuiIsoAnimationViewer viewer = (GuiIsoAnimationViewer)this.get("viewer");
        door.center = new StructureRelative(viewer.getBox(), viewer.getGrid());
        GuiComboBox inter = (GuiComboBox)this.get("inter");
        door.interpolation = (ValueInterpolation)((Object)inter.selected());
        door.differentTransition = ((GuiTabs)this.get("tabs", GuiTabs.class)).index() != 0;
        door.stayAnimated = ((GuiCheckBox)this.get((String)"stayAnimated", GuiCheckBox.class)).value;
        door.rightClick = ((GuiCheckBox)this.get((String)"rightClick", GuiCheckBox.class)).value;
        door.noClip = ((GuiCheckBox)this.get((String)"noClip", GuiCheckBox.class)).value;
        door.playPlaceSounds = ((GuiCheckBox)this.get((String)"playPlaceSounds", GuiCheckBox.class)).value;
        door.duration = ((GuiTextfield)this.get("duration", GuiTextfield.class)).parseInteger();
        GuiTimelineConfig config = door.differentTransition ? this.different : this.same;
        door.putState(new AnimationState("closed", config.closedState(), !door.stayAnimated));
        door.putState(new AnimationState("opened", config.openedState(), !door.stayAnimated));
        door.putTransition("closed", "opened", "opening", config.generateTimeline(door.duration, door.interpolation, true));
        door.putTransition("opened", "closed", "closing", config.generateTimeline(door.duration, door.interpolation, false));
        return structure;
    }

    public static class GuiTimelineConfigSame
    extends GuiAnimationTimelinePanel
    implements GuiTimelineConfig {
        public static AnimationTimeline setup(PhysicalState closed, PhysicalState opened, int duration, AnimationTimeline original) {
            ArrayList<AnimationTimeline.AnimationEventEntry> events = new ArrayList<AnimationTimeline.AnimationEventEntry>();
            for (AnimationTimeline.AnimationEventEntry entry : original.allEvents()) {
                events.add(entry.copy());
            }
            AnimationTimeline timeline = new AnimationTimeline(original.duration, events);
            for (PhysicalPart part : PhysicalPart.values()) {
                ValueCurveInterpolation.LinearCurve<Vec1d> curve = original.get(part).isEmpty() ? new ValueCurveInterpolation.LinearCurve<Vec1d>() : (ValueCurveInterpolation)original.get(part).copy();
                timeline.set(part, curve);
                if (opened.get(part) == 0.0 && closed.get(part) == 0.0 && curve.isEmpty()) continue;
                if (curve.isEmpty() || closed.get(part) != ((Vec1d)curve.getFirst()).x) {
                    curve.add(0, new Vec1d(closed.get(part)));
                }
                if (!curve.isEmpty() && opened.get(part) == ((Vec1d)curve.getLast()).x) continue;
                curve.add(timeline.duration, new Vec1d(opened.get(part)));
            }
            return timeline;
        }

        public GuiTimelineConfigSame(GuiTreeItemStructure item, GuiBlueprintAnimationHandler handler, PhysicalState closed, PhysicalState opened, int duration, AnimationTimeline timeline) {
            super(item, handler, duration, GuiTimelineConfigSame.setup(closed, opened, duration, timeline), false);
        }

        @Override
        public PhysicalState openedState() {
            PhysicalState state = new PhysicalState();
            for (PhysicalPart part : PhysicalPart.values()) {
                GuiAdvancedTimelineChannel channel = this.get(part);
                if (channel.isChannelEmpty()) continue;
                state.set(part, (Double)channel.getLast().value);
            }
            return state;
        }

        @Override
        public PhysicalState closedState() {
            PhysicalState state = new PhysicalState();
            for (PhysicalPart part : PhysicalPart.values()) {
                GuiAdvancedTimelineChannel channel = this.get(part);
                if (channel.isChannelEmpty()) continue;
                state.set(part, (Double)channel.getFirst().value);
            }
            return state;
        }

        @Override
        public AnimationTimeline generateTimeline(int duration, ValueInterpolation interpolation, boolean opening) {
            AnimationTimeline timeline = this.generateTimeline(duration, interpolation);
            if (!opening) {
                timeline.reverse(this.handler.context());
            }
            return timeline;
        }

        @Override
        public boolean openingAnimation() {
            return true;
        }
    }

    public static interface GuiTimelineConfig {
        public PhysicalState closedState();

        public PhysicalState openedState();

        public AnimationTimeline generateTimeline(int var1, ValueInterpolation var2, boolean var3);

        public boolean openingAnimation();

        public void durationChanged(int var1);
    }

    public static class GuiTimelineConfigDifferent
    extends GuiParent
    implements GuiTimelineConfig {
        public GuiPhysicalStateControl closed;
        public GuiPhysicalStateControl opened;
        public GuiAnimationTimelinePanel opening;
        public GuiAnimationTimelinePanel closing;

        public GuiTimelineConfigDifferent(GuiTreeItemStructure item, GuiBlueprintAnimationHandler handler, PhysicalState closedState, PhysicalState openedState, int duration, AnimationTimeline opening, AnimationTimeline closing) {
            this.flow = GuiFlow.STACK_Y;
            GuiParent stateConfig = new GuiParent();
            this.add((GuiControl)stateConfig);
            GuiParent closedParent = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.CENTER);
            stateConfig.add((GuiControl)closedParent);
            closedParent.add((GuiControl)new GuiLabel("closedLabel").setTranslate("gui.door.closed"));
            this.closed = new GuiPhysicalStateControl("closed", closedState);
            closedParent.add((GuiControl)this.closed);
            GuiParent openedParent = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.CENTER);
            stateConfig.add((GuiControl)openedParent);
            openedParent.add((GuiControl)new GuiLabel("openedLabel").setTranslate("gui.door.opened"));
            this.opened = new GuiPhysicalStateControl("opened", openedState);
            openedParent.add((GuiControl)this.opened);
            GuiTabs tabs = new GuiTabs("timelineTabs");
            this.add((GuiControl)tabs);
            this.opening = new GuiAnimationTimelinePanel(item, handler, duration, opening, true);
            tabs.createTab((Component)GuiTimelineConfigDifferent.translatable((String)"gui.door.opening")).add((GuiControl)this.opening);
            this.closing = new GuiAnimationTimelinePanel(item, handler, duration, closing, true);
            tabs.createTab((Component)GuiTimelineConfigDifferent.translatable((String)"gui.door.closing")).add((GuiControl)this.closing);
            tabs.select(0);
        }

        @Override
        public PhysicalState openedState() {
            return this.opened.create();
        }

        @Override
        public PhysicalState closedState() {
            return this.closed.create();
        }

        @Override
        public AnimationTimeline generateTimeline(int duration, ValueInterpolation interpolation, boolean opening) {
            return opening ? this.opening.generateTimeline(duration, interpolation) : this.closing.generateTimeline(duration, interpolation);
        }

        @Override
        public boolean openingAnimation() {
            return ((GuiTabs)this.get("timelineTabs", GuiTabs.class)).index() == 0;
        }

        @Override
        public void durationChanged(int duration) {
            this.opening.durationChanged(duration);
            this.closing.durationChanged(duration);
        }
    }

    public static class GuiAdvancedTimelineChannel
    extends GuiTimelineChannelDouble {
        public final boolean distance;
        public final boolean limited;
        private int lastDuration;
        private GuiTimelineKey<Double> start;
        private GuiTimelineKey<Double> end;

        public GuiAdvancedTimelineChannel(GuiTimeline timeline, boolean distance, boolean limited) {
            super(timeline);
            this.distance = distance;
            this.limited = limited;
            this.updateFixedKeys();
        }

        private void updateFixedKeys() {
            if (!this.limited || this.lastDuration == this.timeline.getDuration()) {
                return;
            }
            this.controls.remove(this.start);
            this.start = new GuiTimelineKey((GuiTimelineChannel)this, 0, (Object)0.0);
            this.start.modifiable = false;
            this.add((GuiControl)this.start);
            this.adjustPosition(this.start);
            this.controls.remove(this.end);
            this.end = new GuiTimelineKey((GuiTimelineChannel)this, this.timeline.getDuration(), (Object)0.0);
            this.end.modifiable = false;
            this.add((GuiControl)this.end);
            this.adjustPosition(this.end);
            this.lastDuration = this.timeline.getDuration();
        }

        @OnlyIn(value=Dist.CLIENT)
        @Environment(value=EnvType.CLIENT)
        protected void renderContent(GuiGraphics graphics, Rect contentRect, Rect realContentRect, double scale, int mouseX, int mouseY) {
            this.updateFixedKeys();
            super.renderContent(graphics, contentRect, realContentRect, scale, mouseX, mouseY);
        }

        public boolean isSpaceFor(GuiTimelineKey<Double> key, int tick) {
            if (this.limited && (tick == 0 || tick == this.timeline.getDuration())) {
                return false;
            }
            return super.isSpaceFor(key, tick);
        }
    }
}

