/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.registry.gui;

import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.control.GuiDirectionIndicator;
import team.creative.littletiles.common.gui.control.GuiDistanceControl;
import team.creative.littletiles.common.gui.control.animation.GuiIsoAnimationViewer;
import team.creative.littletiles.common.gui.tool.blueprint.GuiTreeItemStructure;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.registry.gui.LittleDoorBaseGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;
import team.creative.littletiles.common.structure.type.animation.LittleSlidingDoor;

@OnlyIn(value=Dist.CLIENT)
public class LittleDoorSlidingGui
extends LittleDoorBaseGui {
    public LittleDoorSlidingGui(LittleStructureGui gui, GuiTreeItemStructure item) {
        super(gui, item);
        this.registerEventChanged(x -> {
            if (x instanceof GuiIsoAnimationViewer.GuiAnimationViewChangedEvent || x.control.is("facing")) {
                GuiIsoAnimationViewer viewer = (GuiIsoAnimationViewer)this.get("viewer");
                GuiComboBox direction = (GuiComboBox)this.get("facing");
                Facing facing = (Facing)direction.selected();
                if (viewer.getXFacing().axis == facing.axis) {
                    facing = viewer.getXFacing().positive == facing.positive ? Facing.EAST : Facing.WEST;
                } else if (viewer.getYFacing().axis == facing.axis) {
                    facing = viewer.getYFacing().positive == facing.positive ? Facing.UP : Facing.DOWN;
                } else if (viewer.getZFacing().axis == facing.axis) {
                    facing = viewer.getZFacing().positive == facing.positive ? Facing.SOUTH : Facing.NORTH;
                }
                ((GuiDirectionIndicator)this.get("relative", GuiDirectionIndicator.class)).setFacing(facing);
            }
            if (x.control.is(new String[]{"distance", "facing"})) {
                this.updateTimeline();
            }
        });
    }

    @Override
    protected boolean hasAxis() {
        return false;
    }

    @Override
    protected void createSpecific(LittleDoor door) {
        Facing facing;
        int distance;
        LittleGrid grid;
        if (door instanceof LittleSlidingDoor) {
            LittleSlidingDoor sliding = (LittleSlidingDoor)door;
            grid = sliding.grid;
            distance = sliding.distance;
            facing = sliding.direction;
        } else {
            grid = this.item.group.getGrid();
            distance = Math.max(this.item.group.getSize().get(Axis.Y) - 1, 1);
            facing = Facing.UP;
        }
        GuiParent settings = new GuiParent((GuiFlow)GuiFlow.FIT_X);
        settings.spacing = 12;
        this.add((GuiControl)settings.setVAlign(VAlign.CENTER));
        settings.add((GuiControl)new GuiLabeledControl((Component)Component.translatable((String)"gui.door.distance").append(":"), (GuiControl)new GuiDistanceControl("distance", grid, distance)));
        GuiParent direction = new GuiParent();
        settings.add((GuiControl)new GuiLabeledControl((Component)Component.translatable((String)"gui.door.direction").append(":"), (GuiControl)direction.setVAlign(VAlign.STRETCH)));
        direction.add((GuiControl)new GuiComboBox("facing", (Object)facing, (IComponentMap)new TextMapBuilder().addComponent((Object[])Facing.VALUES, x -> x.translate())));
        direction.add((GuiControl)new GuiDirectionIndicator("relative", Facing.UP));
    }

    @Override
    public void create(LittleStructure structure) {
        super.create(structure);
        GuiComboBox facingControl = (GuiComboBox)this.get("facing");
        GuiIsoAnimationViewer viewer = (GuiIsoAnimationViewer)this.get("viewer");
        if (((Facing)facingControl.selected()).axis == Axis.Y) {
            viewer.setView(Facing.EAST);
        }
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)facingControl));
    }

    @Override
    public LittleStructure save(LittleStructure structure) {
        LittleSlidingDoor door = (LittleSlidingDoor)super.save(structure);
        GuiComboBox facingControl = (GuiComboBox)this.get("facing");
        GuiDistanceControl distance = (GuiDistanceControl)this.get("distance");
        door.distance = distance.getDistance();
        door.grid = distance.getDistanceGrid();
        door.direction = (Facing)facingControl.selected();
        return door;
    }

    @Override
    protected void save(PhysicalState state) {
        GuiComboBox direction = (GuiComboBox)this.get("facing");
        GuiDistanceControl distance = (GuiDistanceControl)this.get("distance");
        state.off(0.0, 0.0, 0.0);
        state.rot(0.0, 0.0, 0.0);
        state.off((Facing)direction.selected(), distance.getVanillaDistance());
    }
}

