/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.registry.gui;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.world.SimpleContainer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.gui.tool.blueprint.GuiTreeItemStructure;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiControl;
import team.creative.littletiles.common.structure.type.LittleStorage;

@OnlyIn(value=Dist.CLIENT)
public class LittleStorageGui
extends LittleStructureGuiControl {
    public LittleStorageGui(LittleStructureGui type, GuiTreeItemStructure item) {
        super(type, item);
    }

    @Override
    public void create(@Nullable LittleStructure structure) {
        this.add((GuiControl)new GuiLabel("space").setTitle(new TextBuilder().text("space: " + LittleStorage.getSizeOfInventory(this.item.group)).build()));
        boolean invisible = false;
        if (structure instanceof LittleStorage) {
            invisible = ((LittleStorage)structure).invisibleStorageTiles;
        }
        this.add((GuiControl)new GuiCheckBox("invisible", invisible).setTranslate("gui.blueprint.storage.invisible"));
    }

    @Override
    public LittleStructure save(LittleStructure structure) {
        LittleStorage storage = (LittleStorage)structure;
        storage.invisibleStorageTiles = ((GuiCheckBox)this.get((String)"invisible")).value;
        Iterator<LittleTile> iterator = this.item.group.iterator();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            if (!tile.getBlock().is(LittleTiles.STORAGE_BLOCKS)) continue;
            tile.color = ColorUtils.setAlpha((int)tile.color, (int)(storage.invisibleStorageTiles ? 0 : 255));
        }
        storage.inventorySize = LittleStorage.getSizeOfInventory(this.item.group);
        storage.stackSizeLimit = 64;
        storage.updateNumberOfSlots();
        storage.inventory = new SimpleContainer(storage.numberOfSlots);
        return structure;
    }
}

